import sipb_xen_database.models as models

# `name' gets passed in from the xm create call

machine = models.Machine.get_by(name=name)
machine_type = models.Type.get_by(type_id=machine.type_id)

memory = machine.memory
maxmem = memory
name = machine.name
uuid = machine.uuid

vcpus = machine.cpus

diskioemu = ""
viftype = ""

if machine_type.hvm:
    ioemu = "ioemu:"
    viftype = "type=ioemu"

    kernel = 'hvmloader'
    builder = 'hvm'
    vnc = 1
    device_model = 'qemu-dm'
else:
    kernel  = '/boot/vmlinuz-2.6.18-4-xen-amd64'
    ramdisk = '/boot/initrd.img-2.6.18-4-xen-amd64'
    builder = 'linux'

pae = machine_type.pae
acpi = machine_type.acpi
apic = machine_type.apic

vif = []

for n in machine.nics:
    d = '%s, mac=%s, ip=%s, bridge=xenbr0' % (viftype, n.mac_addr, n.ip)
    vif.append(disk)

disk = []

for d in machine.disks:
    device = 'xenvg/' + machine.name + '_' + d.guest_device_name
    dspec = 'phy:%s,%s%s,w' % (device, diskioemu, d.guest_device_name)
    disk.append(dspec)

restart = 'destroy'
if machine.autorestart:
    restart = 'restart'

on_poweroff = 'destroy'
on_reboot = 'restart'
on_crash = restart
