#!/bin/sh
# Invirt install script.
# Cribbed from install-debathena.sh.
set -e

output() {
    printf '\033[38m'; echo "$@"; printf '\033[0m'
}

error() {
    ret=`shift`
    printf '\033[31m'; echo "$@"; printf '\033[0m'
    exit $ret
}

if [ `id -u` != "0" ]; then
    error 1 "You must run the Invirt installer as root."
fi

output "Installing the dependencies for the Invirt installer..."
aptitude install lsb-release wget
DISTRO=`lsb_release -cs`
case $DISTRO in
    hardy)
        ;;
    *)
        error 1 'Invirt only supports Ubuntu hardy right now, sorry.'
        ;;
esac

output "Adding repositories to the apt sources..."
(
    echo debathena http://debathena.mit.edu/apt $DISTRO debathena debathena-config openafs 
    echo invirt http://xvm.mit.edu/invirt stable main
) | while read name line; do
    sourceslist="/etc/apt/sources.list.d/$name.list"
    if [ -e $sourceslist ]; then
        continue
    fi
    echo "deb     $line" >> "$sourceslist"
    echo "deb-src $line" >> "$sourceslist"
done

# if [ "$UBUNTU" = "yes" ]; then
#     output "Making sure the universe repository is enabled"
#     sed -i 's,^# \(deb\(\-src\)* http://archive.ubuntu.com/ubuntu [[:alnum:]]* universe\)$,\1,' /etc/apt/sources.list
# fi

output "Downloading archive keys..."
(
  echo http://debathena.mit.edu/apt/debathena-archive.asc 503f95f71077c03947797932d3a1c424be0eced7
  echo http://xvm.mit.edu/invirt/invirt-archive.asc a7ca522933fa3e4661b4ee6c18044e9740b1567c
) | while read uri sha1; do
  f=$(mktemp archive.asc.XXXX)
  wget -O $f $uri
  echo "$sha1  $f" | sha1sum -c
  apt-key add $f
  rm $f
done

aptitude update

#output "Installing Invirt..."
#DEBIAN_FRONTEND=noninteractive aptitude install invirt-host-master

output "Invirt installation done!"
output ""
output "You probably want to ask invirt@mit.edu what to do next, if you're"
output "not yourself one of the people who would answer that question."
output "We're still working on documentation."
