<%page expression_filter="h"/>
<%def name="databaseList(lst, default, onchange, name, id, valueattr, descattr)">
<select name="${name}" id="${id}" \
% if onchange:
onchange="${onchange}"\
% endif
>
  <option ${'' if default else 'selected'} value="">None</option>
  %for item in lst:
  <option ${'selected' if default == getattr(item, valueattr) else ''} value="${getattr(item, valueattr)}">
    ${getattr(item, descattr)}
  </option>
  % endfor
</select>
</%def>

<%def name="cdromList(default='', onchange=None)">
${databaseList(sorted(database.CDROM.query(), key=lambda x: x.description),
               default, onchange, 'cdrom', 'cdromlist', 'cdrom_id', 'description')|n}
</%def>

<%def name="autoList(default='', onchange=None)">
${databaseList(sorted(database.Autoinstall.query(), key=lambda x: x.description),
               default, onchange, 'autoinstall', 'autoinstalllist', 'autoinstall_id', 'description')|n}
</%def>

<%def name="vmTypeList(default=None)">
% for vmtype in (('linux-hvm', 'HVM'), ('linux', 'ParaVM'), ):
<label>
   <input ${'checked="checked"' if default == vmtype[0] else '' | n} type="radio" name="vmtype" id="vmtype-${vmtype[0]}" value="${vmtype[0]}" />${vmtype[1]}
</label>
% endfor
</%def>

<%def name="errorRow(value, err)">
% if err and err.err_field == value:
<tr>
<td class="error" colspan="2">${str(err)}</td>
</tr>
% endif
</%def>

<%!
def jquote(string):
    return "'" + string.replace('\\', '\\\\').replace("'", "\\'").replace('\n', '\\n') + "'"

def nl2br(string):
    return string.replace('\n', '<br/>')
%>

<%def name="helppopup(subj)">
## Return HTML code for a (?) link to a specified help topic
<span class="helplink"><a href="help?simple=true;subject=${subj | u}" target="_blank" onclick="return helppopup(${subj | jquote})">(?)</a></span>
</%def>
