<%page args="cfg, invirt_ssl" />

% if cfg.web.sites.svn.port not in [80, 443]:
  Listen ${cfg.web.sites.svn.port}
% endif
<VirtualHost *:${cfg.web.sites.svn.port}>
	ServerAdmin ${cfg.web.errormail}
	ServerName ${cfg.web.hostname}:${cfg.web.sites.svn.port}
	
	<Directory />
		Options FollowSymLinks
		AllowOverride None
	</Directory>
	<Location />
		DAV svn
		SVNPath ${cfg.web.sites.svn.repopath}
		AuthType Basic
		AuthName "${cfg.web.sites.svn.authname}"
		AuthUserFile ${cfg.web.sites.svn.get('dav', '/etc/apache2/dav_svn.passwd')}
		<LimitExcept GET PROPFIND OPTIONS REPORT>
			Require valid-user
		</LimitExcept>
	</Location>

	ErrorLog /var/log/apache2/error.log

	# Possible values include: debug, info, notice, warn, error, crit,
	# alert, emerg.
	LogLevel warn

	CustomLog /var/log/apache2/svn_access.log combined
	ServerSignature On

	SSLEngine on

	SSLCertificateFile ${cfg.web.ssl.cert}
	SSLCertificateKeyFile ${cfg.web.ssl.key}
</VirtualHost>

Alias ${cfg.web.sites.svn.alias} ${cfg.web.sites.svn.localpath}

<Directory /${cfg.web.sites.svn.localpath}>
		Options Indexes FollowSymLinks MultiViews
		AllowOverride None
		Order allow,deny
		allow from all
</Directory>
