<%page args="cfg, invirt_ssl" />

NameVirtualHost *:80
<VirtualHost *:80>
	ServerAdmin ${cfg.web.errormail}
        ServerName ${cfg.web.hostname}:80
	
	DocumentRoot /var/www/invirt-web
	<Directory /var/www/invirt-web>
		Options Indexes FollowSymLinks MultiViews ExecCGI
		AllowOverride None
		Order allow,deny
		allow from all
	</Directory>

	RewriteEngine On
	RewriteRule ^/static(.*) - [L]
	RewriteRule ^/admin/static(.*) /static/$1 [L]
% for rewrite in cfg.web.sites.default.rewriterules:
	RewriteRule ^/${rewrite.rule} ${rewrite.target} [${rewrite.type}]
% endfor
	RewriteRule ^/(.*) /var/www/invirt-web/unauth.fcgi/$1 [L]

	ErrorLog /var/log/apache2/error.log

	# Possible values include: debug, info, notice, warn, error, crit,
	# alert, emerg.
	LogLevel notice

	CustomLog /var/log/apache2/access.log combined


	ServerSignature On
	% for redirect in cfg.web.sites.default.redirects:
	  Redirect /${redirect.rule} ${redirect.target}
	% endfor
</VirtualHost>
