from record import NullableRecord

class Owner(NullableRecord):
    _f = {
        'ram_quota_total': (512, 'MiB'),
        'ram_quota_single': (512, 'MiB'),
        'disk_quota_total': (50, 'GiB'),
        'disk_quota_single': (50, 'GiB'),
        'vms_quota_total': (10, ''),
        'vms_quota_active': (4, '')
    }
    _default = dict([(_k,_v[0]) for _k,_v in _f.items()])
    def _unitFormatter(unit):
        return lambda v:'%s%s'%(v,unit)
    _format = dict([(_k,_unitFormatter(_v[1])) for _k,_v in _f.items()])
    _identity_field = 'owner_id'

    @classmethod
    def getMemoryQuotas(cls, owner):
        owner_info = cls.query().filter_by(owner_id=owner).first()
        if owner_info == None:
            owner_info = cls(owner_id=owner)
        return (owner_info.get('ram_quota_total'), owner_info.get('ram_quota_single'))

    @classmethod
    def getDiskQuotas(cls, owner):
        owner_info = cls.query().filter_by(owner_id=owner).first()
        if owner_info == None:
            owner_info = cls(owner_id=owner)
        return (owner_info.get('disk_quota_total'), owner_info.get('disk_quota_single'))

    @classmethod
    def getVMQuotas(cls, owner):
        owner_info = cls.query().filter_by(owner_id=owner).first()
        if owner_info == None:
            owner_info = cls(owner_id=owner)
        return (owner_info.get('vms_quota_total'), owner_info.get('vms_quota_active'))
