MAX_MEMORY_TOTAL = 512
MAX_MEMORY_SINGLE = 512
MAX_DISK_TOTAL = 50
MAX_DISK_SINGLE = 50
MAX_VMS_TOTAL = 10
MAX_VMS_ACTIVE = 4

class Owner(object):
    def __repr__(self):
        return """<Owner %s: ram_quota_total=%s MB ram_quota_single=%s MB
disk_quota_total=%s MB disk_quota_single=%s MB
vms_quota_total=%s vms_quota_active=%s >""" % (self.owner_id, 
               self.ram_quota_total if self.ram_quota_total else MAX_MEMORY_TOTAL,
               self.ram_quota_single if self.ram_quota_single else MAX_MEMORY_SINGLE, 
               self.disk_quota_total if self.disk_quota_total else MAX_DISK_TOTAL,
               self.disk_quota_single if self.disk_quota_single else MAX_DISK_SINGLE, 
               self.vms_quota_total if self.vms_quota_total else MAX_VMS_TOTAL,
               self.vms_quota_active if self.vms_quota_active else MAX_VMS_ACTIVE)
    def getMemoryQuotas(owner):
        owner_info = Owner.query().filter_by(owner_id=owner).first()
        if owner_info != None:
            quota_total = owner_info.ram_quota_total
            if quota_total == None:
                quota_total = MAX_MEMORY_TOTAL
            quota_single = owner_info.ram_quota_single
            if quota_single == None:
                quota_single = MAX_MEMORY_SINGLE
        else:
            quota_total = MAX_MEMORY_TOTAL
            quota_single = MAX_MEMORY_SINGLE
        return (quota_total, quota_single)
    getMemoryQuotas = staticmethod(getMemoryQuotas)
    def getDiskQuotas(owner):
        owner_info = Owner.query().filter_by(owner_id=owner).first()
        if owner_info != None:
            quota_total = owner_info.disk_quota_total
            if quota_total == None:
                quota_total = MAX_DISK_TOTAL
            quota_single = owner_info.disk_quota_single
            if quota_single == None:
                quota_single = MAX_DISK_SINGLE
        else:
            quota_total = MAX_DISK_TOTAL
            quota_single = MAX_DISK_SINGLE
        return (quota_total, quota_single)
    getDiskQuotas = staticmethod(getDiskQuotas)
    def getVMQuotas(owner):
        owner_info = Owner.query().filter_by(owner_id=owner).first()
        if owner_info != None:
            quota_total = owner_info.vms_quota_total
            if quota_total == None:
                quota_total = MAX_VMS_TOTAL
            quota_active = owner_info.vms_quota_active
            if quota_active == None:
                quota_active = MAX_VMS_ACTIVE
        else:
            quota_total = MAX_VMS_TOTAL
            quota_active = MAX_VMS_ACTIVE
        return (quota_total, quota_active)
    getVMQuotas = staticmethod(getVMQuotas)
