#!/bin/bash
set -e

mako-render rules.mako > rules

rm git -rf
mkdir git
cd git

sed -n 's/^create repository // p' ../rules | while read repo; do
    mkdir -p "$repo" && GIT_DIR="$repo" git init --bare
done

echo run > ../run.gdb
gdb -batch -x ../run.gdb --args svn-all-fast-export ../rules /home/anders/xvm/svn

sed -n 's/^create repository // p' ../rules | while read repo; do
    ! [ -e "$repo/refs/heads/tags" ] || \
	cp -a "$repo/refs/heads/tags/." "$repo/refs/tags" && \
	rm -rf "$repo/refs/heads/tags"
done
