#!/bin/sh
DIR=/etc/remctl/sipb-xen-auto
TEMPLATE=$DIR/conf.template
MACHINEDIR=$DIR/machine.d
MOIRADIR=$DIR/moira-acl
MOIRATMP=$DIR/moira-tmp
MACHINETMP=$DIR/machine-list-tmp
AUTOMACHINELIST=$DIR/auto-machine-list
AUTOMOIRALIST=$DIR/auto-moira-list
BINDIR=/usr/sbin
ACLDIR=$DIR/acl

update_machine()
{
    machine="$1"
    sed "s/#MACHINENAME#/$machine/g" "$TEMPLATE" | \
	sed "s,#BINDIR#,$BINDIR,g" >| "$MACHINETMP"
    if ! cmp -s "$MACHINEDIR/$machine" "$MACHINETMP"; then
	mv "$MACHINETMP" "$MACHINEDIR/$machine"
    else
	rm -f "$MACHINETMP"
    fi
}

update_moiragroup()
{
    group="$1"
    # Should perhaps replace with LDAP, but fine for now.

    # We should do more careful error checking so we don't take away
    # all bits and delete the moira-acl files whenever there's an AFS
    # outage.
    pts membership system:"$group" -noauth | tail -n+2 | \
	sed 's/\./\//' | \
	sed 's/^  //' | \
	sed 's/$/@ATHENA.MIT.EDU/g' >| "$MOIRATMP"
    if test -s "$MOIRATMP"; then
	if ! cmp -s "$MOIRADIR/$group" "$MOIRATMP"; then
	    mv "$MOIRATMP" "$MOIRADIR/$group"
	fi
    else
	if test -e "$MOIRADIR/$group"; then
	    rm "$MOIRADIR/$group"
	fi
    fi
    rm -f "$MOIRATMP"
}

check_machine_name()
{
    machine="$1"
    if ! perl -0e 'exit($ARGV[0] !~ /^[A-Za-z0-9][A-Za-z0-9._-]*$/)' -- "$machinename"; then
	echo "Bad machine name"
	exit 1
    fi
}

case "$1" in
    moiragroup)
	update_moiragroup "$2"
	;;

    all_machines)
        # update the remctl.conf definitions
	for machine in `cat "$AUTOMACHINELIST"`; do
	    update_machine "$machine"
	done
	;;
    all_moira)
        # update our moira ACL lists
	for group in `cat "$AUTOMOIRALIST"`; do
	    update_moiragroup "$group"
	done
	;;
    auto_machine_list)
        # update the list of maintained machines
	/bin/ls "$ACLDIR" >| "$AUTOMACHINELIST"
	;;
    auto_moira_list)
        # update the moira list-of-lists
        # /bin/ls "$MOIRADIR" >| "$AUTOMOIRALIST" # BAD IDEA in case of outage

	# This extracts the list of all moira lists we care about, and updates those.
	grep -R moira "$ACLDIR/" /etc/remctl/acl/ | perl -pe 's/.*moira-acl\/(.*)/$1/g' >| "$AUTOMOIRALIST"
	;;
    unregister)
	machine="$2"
	check_machine_name "$machine"
	rm -f "$ACLDIR"/"$machine"
	rm -f "$MACHINEDIR"/"$machine"
	"$0" web
	;;
    moveregister)
        oldmachine="$2"
        newmachine="$3"
	check_machine_name "$oldmachine"
	check_machine_name "$newmachine"
        mv "$ACLDIR"/"$oldmachine" "$ACLDIR"/"$newmachine"
        rm -f "$MACHINEDIR"/"$oldmachine"
        "$0" web
	;;
    register)
	machine="$2"
	check_machine_name "$machine"
	if [ -e "$ACLDIR"/"$machine" ]; then
	    echo "Machine already registered"
	    exit 1
	fi
	echo "include /etc/remctl/acl/web" > "$ACLDIR/$machine"
	"$0" web
	;;
    web)
	"$0" auto_machine_list
	"$0" all_machines
	;;	
    remctl-moira-update|all)
    	"$0" auto_machine_list
	"$0" all_machines
	"$0" auto_moira_list
	"$0" all_moira
	;;
esac

exit 0
