#!/bin/sh
# dispatch-ACTION.sh MACHINE
#
# remctl should have already verified that the user is authorized to
# control the machine.  So, we just need to execute the action requested.
#
# $0 and $1 come from the trusted remctl source.
#
# $2 and so on are user-provided, and thus sketchy.  I don't think we
# need them for this script.

ACTION=$(echo "$0" | awk -F'.' '{print $2}')
ORIGMACHINE="$1"
MACHINE="d_$ORIGMACHINE"

case "$ACTION" in
    list|vcpu-list|destroy|create|uptime|shutdown)
        xm "$ACTION" "$MACHINE"
	;;
    reboot-with-cdrom)
	xm shutdown "$MACHINE"
	xm create sipb-database machine_name="$ORIGMACHINE" cdrom_image="$2"
	;;
    reboot)
	if [ -n "$2" ]; then
	    /usr/sbin/dispatch.reboot-with-cdrom.sh "$ORIGMACHINE" "$2" &
	else
	    xm reboot "$MACHINE"
	fi
	;;
    list-long)
	xm list --long "$MACHINE"
	;;
    *)
        echo "ERROR: Invalid Command"
        exit 1
        ;;
esac
