import json
from invirt.common import *
from os.path import getmtime

default_src_path   = '/etc/invirt/master.yaml'
default_cache_path = '/var/lib/invirt/cache.json'

try:    default_loader = yaml.CSafeLoader
except: default_loader = yaml.SafeLoader

def load(src_path = default_src_path,
         cache_path = default_cache_path,
         force_refresh = False):
    """
    Try loading the configuration from the faster-to-load JSON cache at
    cache_path.  If it doesn't exist or is outdated, load the configuration
    instead from the original YAML file at src_path and regenerate the cache.
    I assume I have the permissions to write to the cache directory.
    """
    if force_refresh:
        do_refresh = True
    else:
        src_mtime = getmtime(src_path)
        try:            cache_mtime = getmtime(cache_path)
        except OSError: do_refresh  = True
        else:           do_refresh  = src_mtime > cache_mtime

    if not do_refresh:
        # try reading from the cache first
        try: cfg = with_closing(file(cache_path))(lambda f: json.read(f.read()))
        except: do_refresh = True

    if do_refresh:
        # Atomically reload the source and regenerate the cache.  The read and
        # write must be a single transaction, or a stale version may be
        # written.
        @with_lock_file('/var/lib/invirt/cache.lock')
        def cfg():
            import yaml
            cfg = with_closing(file(src_path))(lambda f: yaml.load(f, default_loader))
            try: with_closing(file(cache_path, 'w'))(lambda f: f.write(json.write(cfg)))
            except: pass # silent failure
            return cfg
    return cfg

dicts = load()
structs = dicts2struct(dicts)

# vim:et:sw=4:ts=4
