import unittest

class struct(object):
    'A simple namespace object.'
    def __init__(self, d = {}):
        'd is the dictionary to update my __dict__ with.'
        self.__dict__.update(d)

def dicts2struct(x):
    """
    Given a tree of lists/dicts, perform a deep traversal to transform all the
    dicts to structs.
    """
    if type(x) == dict:
        return struct((k, dicts2struct(v)) for k,v in x.iteritems())
    elif type(x) == list:
        return [dicts2struct(v) for v in x]
    else:
        return x

def wrap(rsrc, func):
    "Utility to that emulates with Python 2.5's `with closing(rsrc)`."
    try: return func(rsrc)
    finally: rsrc.close()

class common_tests(unittest.TestCase):
    def test_dicts2structs(self):
        dicts = {
                'atom': 0,
                'dict': { 'atom': 'atom', 'list': [1,2,3] },
                'list': [ 'atom', {'key': 'value'} ]
                }
        structs = dicts2struct(dicts)
        self.assertEqual(structs.atom,        dicts['atom'])
        self.assertEqual(structs.dict.atom,   dicts['dict']['atom'])
        self.assertEqual(structs.dict.list,   dicts['dict']['list'])
        self.assertEqual(structs.list[0],     dicts['list'][0])
        self.assertEqual(structs.list[1].key, dicts['list'][1]['key'])

if __name__ == '__main__':
    unittest.main()
