import json, yaml
from os import error, makedirs
from os.path import dirname, getmtime

default_src_path   = '/etc/invirt/master.yaml'
default_cache_path = '/var/lib/invirt/invirt.json'

try:    default_loader = yaml.CSafeLoader
except: default_loader = yaml.SafeLoader

def wrap(rsrc, func):
    "Utility to that emulates with Python 2.5's `with closing(rsrc)`."
    try: return func(rsrc)
    finally: rsrc.close()

def load(src_path = default_src_path,
         cache_path = default_cache_path,
         force_refresh = False):
    """
    Try loading the configuration from the faster-to-load JSON cache at
    cache_path.  If it doesn't exist or is outdated, load the configuration
    instead from the original YAML file at src_path and regenerate the cache.
    I assume I have the permissions to write to the cache directory.
    """
    if force_refresh:
        do_refresh = True
    else:
        src_mtime = getmtime(src_path)
        try:            cache_mtime = getmtime(cache_path)
        except OSError: do_refresh  = True
        else:           do_refresh  = src_mtime > cache_mtime

    if do_refresh:
        # reload the source and regenerate the cache
        cfg = wrap(file(src_path), lambda f: yaml.load(f, default_loader))
        wrap(file(cache_path, 'w'), lambda f: f.write(json.write(cfg)))
    else:
        cfg = wrap(file(cache_path), lambda f: json.read(f.read()))
    return cfg

# vim:et:sw=4:ts=4
