### Master template
<%!
from invirt.config import structs as cfg
from invirt.config import safestructs as safecfg
%>
<%def name="invirt_ssl()">
	DocumentRoot /var/www/invirt-web
	<Directory /var/www/invirt-web>
		Options Indexes FollowSymLinks MultiViews ExecCGI
		AllowOverride None
		Order allow,deny
		allow from all
	</Directory>
	<Location />
${caller.body()}
	</Location>

	RewriteEngine On
	RewriteRule ^/favicon.ico - [L]
	RewriteRule ^/static(.*) - [L]
	RewriteRule ^/overlord/static(.*) /static/$1 [L]
	RewriteRule ^/admin/static(.*) /static/$1 [L]

% for rewrite in safecfg.web.ssl.rewriterules:
	RewriteRule ^/${rewrite.rule} ${rewrite.target} [${rewrite.type}]
% endfor
	RewriteRule ^/(.*) /var/www/invirt-web/auth.fcgi/$1 [L]

	RewriteLog /var/log/apache2/rewrite.log
	RewriteLogLevel 0 

	ErrorLog /var/log/apache2/error.log

	# Possible values include: debug, info, notice, warn, error, crit,
	# alert, emerg.
	LogLevel warn

	CustomLog /var/log/apache2/ssl_access.log combined
	ServerSignature On

	SSLEngine on

	SSLCertificateFile ${cfg.web.ssl.cert}
	SSLCertificateKeyFile ${cfg.web.ssl.key}
	
	SSLCACertificateFile ${cfg.web.ssl.ca}
	SSLVerifyDepth 10

	SSLOptions +StdEnvVars
	
	SetEnvIf User-Agent ".*MSIE.*" nokeepalive ssl-unclean-shutdown downgrade-1.0 force-response-1.0
% for redirect in safecfg.web.ssl.redirects:
	Redirect /${redirect.rule} ${redirect.target}
% endfor
</%def>

% for site in cfg.web.sites:
<%include file="${site}.mako" args="cfg=cfg, invirt_ssl=invirt_ssl" />
% endfor
