<%page args="cfg, invirt_ssl" />

Listen ${cfg.web.sites.svn.port}
<VirtualHost *:${cfg.web.sites.svn.port}>
	ServerAdmin ${cfg.web.errormail}
	ServerName ${cfg.web.hostname}:${cfg.web.sites.svn.port}
	
	<Directory />
		Options FollowSymLinks
		AllowOverride None
	</Directory>
	<Location />
		DAV svn
		SVNPath ${cfg.web.svn.repopath}
		AuthType Basic
		AuthName "${cfg.web.svn.authname}"
		AuthUserFile ${cfg.web.svn.get('dav', '/etc/apache2/dav_svn.passwd')}
		<LimitExcept GET PROPFIND OPTIONS REPORT>
			Require valid-user
		</LimitExcept>
	</Location>

	ErrorLog /var/log/apache2/error.log

	# Possible values include: debug, info, notice, warn, error, crit,
	# alert, emerg.
	LogLevel warn

	CustomLog /var/log/apache2/svn_access.log combined
	ServerSignature On

	SSLEngine on

	SSLCertificateFile ${cfg.web.ssl.cert}
	SSLCertificateKeyFile ${cfg.web.ssl.key}
</VirtualHost>

Alias /${cfg.web.svn.alias} /${cfg.web.svn.localpath}

<Directory /${cfg.web.svn.localpath}>
		Options Indexes FollowSymLinks MultiViews
		AllowOverride None
		Order allow,deny
		allow from all
</Directory>
