<%page args="cfg, invirt_ssl" />

Listen ${cfg.web.sites.noauth.port}
<VirtualHost *:${cfg.web.sites.noauth.port}>
	ServerAdmin ${cfg.web.errormail}
	ServerName ${cfg.web.hostname}:${cfg.web.sites.noauth.port}
	
	DocumentRoot /var/www/invirt-web
	<Directory />
		Options Indexes FollowSymLinks MultiViews ExecCGI
		AllowOverride None
		Order allow,deny
		allow from all
	</Directory>

	ErrorLog /var/log/apache2/error.log

	# Possible values include: debug, info, notice, warn, error, crit,
	# alert, emerg.
	LogLevel warn

	CustomLog /var/log/apache2/ssl_nocert_access.log combined
	ServerSignature On

	SSLEngine on

	SSLCertificateFile ${cfg.web.ssl.cert}
	SSLCertificateKeyFile ${cfg.web.ssl.key}
	
	SSLVerifyClient none

	SSLOptions +StdEnvVars
	
	SetEnvIf User-Agent ".*MSIE.*" nokeepalive ssl-unclean-shutdown downgrade-1.0 force-response-1.0	
</VirtualHost>
