<%page expression_filter="h"/>
<%inherit file="skeleton.mako" />
<%!
	import datetime
%>


<%def name="title()">
VM List
</%def>

<%def name="createForm()">
% if cant_add_vm:
<p>${cant_add_vm}</p>
% else:
<h2>Create a new VM</h2>
% if err:
<p class="error">We had a problem with your request:</p>
% elif new_machine:
<p>Congratulations! You successfully created a new VM called ${new_machine}.</p>
% endif
    <form action="create" method="POST">
    <input type="hidden" name="back" value="list"/>
      <table>
	${self.fn.errorRow('create', err)}
	<tr>
	  <td>Name</td>
	  <td><input type="text" name="name" value="${defaults.name}"/>.${config.dns.domains[0]}</td>
	</tr>
	${self.fn.errorRow('name', err)}
	<tr>
	  <td>Description</td>
	  <td><textarea name="description" rows="4" cols="60">${defaults.description}</textarea></td>
	</tr>
	${self.fn.errorRow('description', err)}
	<tr>
	  <td>Memory</td>
	  <td><input type="text" name="memory" value="${defaults.memory}" size=3/> MiB (${max_memory} max)</td>
	</tr>
	${self.fn.errorRow('memory', err)}
	<tr>
	  <td>Disk</td>
	  <td><input type="text" name="disksize" value="${defaults.disk}" size=3/> GiB (${"%0.1f" % (max_disk-0.05)} max)</td>
	</tr>
	${self.fn.errorRow('disk', err)}
        <tr>
          <td>HVM/ParaVM${self.fn.helppopup('HVM/ParaVM')}</td>
          <td>
	  ${self.fn.vmTypeList(defaults.type)}
	  </td>
        </tr>
	${self.fn.errorRow('vmtype', err)}
	${self.fn.errorRow('autoinstall', err)}
	<tr>
	  <td>Autoinstall${self.fn.helppopup('Autoinstalls')}</td>
	  <td><label><input type="radio" name="cd_or_auto" id="cd_or_auto_auto"
                 onchange="$('cdromlist').value = ''; $('vmtype-linux').checked = true" />
${self.fn.autoList(defaults.cdrom, "$('cd_or_auto_auto').checked = true;$('cdromlist').value = '';$('vmtype-linux').checked = true")}
	      (experimental; 2-3 minutes, and you have a machine with empty root password.)
</label></td>
	</tr>
	<tr>
	  <td>Boot CD</td>
	  <td><label><input type="radio" name="cd_or_auto" id="cd_or_auto_cd" checked="checked"
                onchange="$('autoinstalllist').value = ''; $('vmtype-linux-hvm').checked = true" />
${self.fn.cdromList(defaults.cdrom, "$('cd_or_auto_cd').checked = true;$('autoinstalllist').value = '';$('vmtype-linux-hvm').checked = true")}
</label></td>
	</tr>
	${self.fn.errorRow('cdrom', err)}
	${self.fn.errorRow('cdrom', err)}
	<tr>
	  <td>Owner</td>
	  <td><input type="text" name="owner" value="${defaults.owner}"/></td>
	</tr>
	${self.fn.errorRow('owner', err)}
      </table>
      <input type="submit" class="button" value="Create it!"/><br />
      Windows notes: ${self.fn.helppopup('Windows')}
    </form>
% endif
</%def>

<%def name="machineRow(machine, dark)">
      <tr\
% if dark:
 class="stripedrow" \
% endif
> 
	<td rowspan="2">
	% if machine.uptime and installing[machine]:
	<img src="static/power_installing.png" alt="Installing..." />
	% else:
	  <form action="machine/${machine.machine_id}/command/${'shutdown' if machine.uptime else 'create'}" method="post">
	    <input type="hidden" name="back" value="list"/>
	    <input type="hidden" name="machine_id"
		   value="${machine.machine_id}"/>
<input type="submit" class="power ${'on' if machine.uptime else 'off'}" name="action" value="${'Shutdown' if machine.uptime else 'Power on'}"\
% if machine.uptime:
 onclick="return confirm('Are you sure you want to power off this VM?');"
% endif
/>
	  </form>
	  % endif
	</td>
	<td><a href="machine/${machine.machine_id}">${machine.name}</a></td>
	<td>${machine.memory}M</td>
	<td>${machine.owner}</td>
	<td>${machine.administrator}</td>
% if machine.nics:
	<td>${', '.join(nic.ip for nic in machine.nics)}</td>
% else:
	<td></td>
% endif
<td>\
% if machine.uptime:
${datetime.timedelta(seconds=int(machine.uptime))}\
% endif
</td>
	<td>\
% if has_vnc[machine] == True:
<a href="machine/${machine.machine_id}/vnc">Console</a>\
% elif has_vnc[machine] == 'ParaVM':
ParaVM${self.fn.helppopup("ParaVM Console")}
% elif has_vnc[machine] != 'Off':
${has_vnc[machine]}
% endif
</td>
      </tr>
      <tr>
        <td colspan="7" style="padding-left: 1em; color: #666">${machine.description|self.fn.module.nl2br}</td>
      </tr>
</%def>

<%def name="machineList(machines)">
    <table cellspacing="0" cellpadding="2">
      <tr>
	<th></th>
	<th>Name</th>
	<th>Memory</th>
	<th>Owner${self.fn.helppopup('Owner')}</th>
        <th>Administrator${self.fn.helppopup('Administrator')}</th>
	<th>IP</th>
	<th>Uptime</th>
	<th>VNC</th>
      </tr>
% for n, machine in enumerate(machines):
	${machineRow(machine, (n%2)==0)}
% endfor
    </table>
</%def>

<p style="font-size: 125%;"><a href="http://${config.web.hostname}">What is XVM?</a></p>
% if not machines:
<p>You don't currently control any VMs.</p>   
% endif
    <p><a href="list">refresh</a></p>
    <div id="machinelist">
    ${machineList(machines)}
    </div>
${createForm()}
