#!/usr/bin/python
"""Main FastCGI entry point for web interface"""

import cherrypy
import os
import sys

import main

dev = False
base_dir = os.path.dirname(__file__)

def usage():
    argv0_dir = os.path.dirname(sys.argv[0])
    print >>sys.stderr, """%s <unauth|auth> [config]
%s/auth.fcgi [config]
%s/unauth.fcgi [config]

Run server as FastCGI, with CherryPy config from "main.conf".

With `config`, run standalone with CherryPy config from `config`.

Run this script as either 'auth.fcgi' or 'unauth.fcgi', to get
the authenticated or unauthenticated site respectively, or pass
'auth' or 'unauth' as the first parameter.
""" % (sys.argv[0], argv0_dir, argv0_dir)
    sys.exit(2)

if __name__ == "__main__":
    if len(sys.argv) > 3 or len(sys.argv) == 1 or '-h' in sys.argv or '--help' in sys.argv:
        usage()
    if len(sys.argv) == 3:
        mode = sys.argv[1]
        conf_file = sys.argv[2]
        dev = True
    else:
        mode = sys.argv[1]
        conf_file = os.path.join(base_dir, 'main.conf')

    app_config = {
        '/': {
            'tools.invirtwebstate.on': True,
            },
        }

    if mode.startswith('auth'):
        root = main.InvirtWeb()
        app_config['/']['tools.mako.module_directory'] = "/tmp/invirt-auth-web-templatecache"
    elif mode.startswith('unauth'):
        root = main.InvirtUnauthWeb()
        app_config['/']['tools.mako.module_directory'] = "/tmp/invirt-unauth-web-templatecache"
    else:
        usage()

    app = cherrypy.tree.mount(root, '/', app_config)
    app.merge(conf_file)
    cherrypy.config.update(conf_file)

    if dev:
        cherrypy.server.quickstart()
        cherrypy.engine.start()
        cherrypy.engine.block()
    else:
        cherrypy.engine.start(blocking=False)
        from flup.server.fcgi import WSGIServer
        server = WSGIServer(cherrypy.tree)
        server.run()
