#!/usr/bin/python
"""Main FastCGI entry point for authenticated web interface"""

import cherrypy
import os
import sys
from main import InvirtWeb

dev = False
base_dir = os.path.dirname(__file__)

def usage():
    print >>sys.stderr, """%s [config]

Run server as FastCGI, with CherryPy config from "main.conf".

With `config`, run standalone with CherryPy config from `config`.
""" % sys.argv[0]
    sys.exit(2)

if __name__ == "__main__":
    static_dir = os.path.join(base_dir, 'static')

    if len(sys.argv) > 2:
        usage()
    if len(sys.argv) > 1:
        if sys.argv[1] in ('-h', '--help'):
            usage()
        conf_file = sys.argv[1]
        dev = True
    else:
        conf_file = os.path.join(base_dir, 'main.conf')

    app_config = {
        '/': {
            'tools.invirtwebstate.on': True,
            },
        '/static': {
            'tools.staticdir.root': static_dir,
            'tools.staticdir.on': True,
            'tools.staticdir.dir': static_dir,
            }
        }
                    
    app = cherrypy.tree.mount(InvirtWeb(),
                              '/',
                              app_config)
    app.merge(conf_file)
    cherrypy.config.update(conf_file)

    if dev:
        cherrypy.server.quickstart()
        cherrypy.engine.start()
        cherrypy.engine.block()
    else:
        cherrypy.engine.start(blocking=False)
        from flup.server.fcgi import WSGIServer
        server = WSGIServer(cherrypy.tree)
        server.run()
