<%page expression_filter="h"/>
<%inherit file="skeleton.mako" />

<%def name="title()">
Info on ${machine.name}
</%def>

<%def name="infoTable()">
<h2>Info</h2>
<table>
  % for key, value in fields:
  <tr><td>${key}:</td><td>${value}</td></tr>
  % endfor
</table>
</%def>

<%def name="commands()">
% if on:
 % if not machine.type.hvm:
  Console access: type
  <tt>ssh ${machine.name}@${config.console.hostname}</tt>
  on Athena. <a href="https://xvm.scripts.mit.edu/wiki/SerialConsole">(more info)</a>
 % elif has_vnc:
  <strong><a href="vnc?machine_id=${machine.machine_id}">Get Console</a></strong>
 % else:
  VNC console not enabled; still booting?
 % endif
% endif
<form action="command" method="POST">
  <input type="hidden" name="back" value="info"/>
  <input type="hidden" name="machine_id" value="${machine.machine_id}"/>
  <div>
	% if on:
	<button type="submit" class="button" name="action" value="Power off">Power off (hard)</button>
	<button type="submit" class="button" name="action" value="Shutdown">Shut down</button>
	<input type="submit" class="button" name="action" value="Reboot"/>
	% else:
	<input type="submit" class="button" name="action" value="Power on"/>
	% endif
  </div>
  <div>
    Boot CD:
${self.fn.cdromList()}
  </div>
  <div>
      <input type="submit" class="button" name="action" value="Delete VM" onclick="return confirm('Are you sure that you want to delete this VM?');"/>
  </div>
</form>
</%def>

<%def name="modifyForm()">
% if err:
<p class="error">We had a problem with your request:</p>
% elif new_machine:
<p>Successfully modified.</p>
% endif
% if on:
(To edit ram, disk size, or machine name, turn off the machine first.)
% endif
<form action="modify" method="POST">
  <input type="hidden" name="machine_id" value="${defaults.machine_id}"/>
  <table>
    <tr><td>Description:</td><td colspan="2"><textarea name="description" rows="4" cols="60">${defaults.description}</textarea></td></tr>
    <tr><td>Owner${self.fn.helppopup("Owner")}:</td><td><input type="text" name="owner", value="${defaults.owner}"/></td></tr>
${self.fn.errorRow('owner', err)}
    <tr><td>Administrator${self.fn.helppopup("Administrator")}:</td><td><input type="text" name="admin", value="${defaults.administrator}"/></td></tr>
${self.fn.errorRow('administrator', err)}
    <tr><td>Contact email:</td><td><input type="text" name="contact" value="${defaults.contact}"/></td></tr>
${self.fn.errorRow('contact', err)}
% if not on:
    <tr><td>Machine Name:</td><td><input type="text" name="name" value="${defaults.name}"/>.${config.dns.domains[0]}</td></tr>
${self.fn.errorRow('name', err)}
    <tr>
      <td>HVM/ParaVM${self.fn.helppopup('HVM/ParaVM')}</td>
      <td>${self.fn.vmTypeList(defaults.type)}</td>
    </tr>
    <tr><td>Ram:</td><td><input type="text" size=3 name="memory" value="${defaults.memory}"/>MiB (max ${max_mem})</td></tr>
${self.fn.errorRow('memory', err)}
    <tr><td>Disk:</td><td><input type="text" size=3 name="disksize" value="${defaults.disk}"/>GiB (max ${max_disk})</td><td>WARNING: Modifying disk size may corrupt your data.</td></tr>
${self.fn.errorRow('disk', err)}
% else:
${self.fn.errorRow('name', err)}
${self.fn.errorRow('memory', err)}
${self.fn.errorRow('disk', err)}
% endif
    <tr><td><input type="submit" class="button" name="action" value="Change"/></td></tr>
  </table>
</form>
</%def>

<div id="info">
  ${infoTable()}
</div>

<h2>Commands</h2>
<div id="commands">
  ${commands()}
</div>
<h2>Settings</h2>
<div id="modify">
  ${modifyForm()}
</div>
