<%inherit file="skeleton.mako" />
<%!
	import datetime
%>


<%def name="title()">
VM List
</%def>

<%def name="createForm()">
% if cant_add_vm:
<p>${cant_add_vm}</p>
% else:
<h2>Create a new VM</h2>
% if err:
<p class="error">We had a problem with your request:</p>
% elif new_machine:
<p>Congratulations! You successfully created a new VM called ${new_machine}.</p>
% endif
    <form action="create" method="POST">
    <input type="hidden" name="back" value="list"/>
      <table>
	${errorRow('create', err)}
	<tr>
	  <td>Name</td>
	  <td><input type="text" name="name" value="${defaults.name}"/>.${config.dns.domains[0]}</td>
	</tr>
	${errorRow('name', err)}
	<tr>
	  <td>Description</td>
	  <td><textarea name="description" rows="4" cols="60">${defaults.description}</textarea></td>
	</tr>
	${errorRow('description', err)}
	<tr>
	  <td>Memory</td>
	  <td><input type="text" name="memory" value="${defaults.memory}" size=3/> MiB (${max_memory} max)</td>
	</tr>
	${errorRow('memory', err)}
	<tr>
	  <td>Disk</td>
	  <td><input type="text" name="disksize" value="${defaults.disk}" size=3/> GiB (${"%0.1f" % (max_disk-0.05)} max)</td>
	</tr>
	${errorRow('disk', err)}
        <tr>
          <td>HVM/ParaVM${fn.helppopup('HVM/ParaVM')}</td>
          <td>
	  ${vmTypeList(defaults.type)}
	  </td>
        </tr>
	${errorRow('vmtype', err)}
	${errorRow('autoinstall', err)}
	<tr>
	  <td>Autoinstall${fn.helppopup('Autoinstalls')}</td>
	  <td><input type="radio" name="cd_or_auto" id="cd_or_auto_auto"
                 onchange="\$('cdromlist').value = ''; \$('vmtype-linux').checked = true">
${autoList(defaults.cdrom, "$('cd_or_auto_auto').checked = true;$('cdromlist').value = '';$('vmtype-linux').checked = true")}
	      (experimental; 2-3 minutes, and you have a machine with empty root password.)
	  </input>
	</tr>
	<tr>
	  <td>Boot CD</td>
	  <td><input type="radio" name="cd_or_auto" id="cd_or_auto_cd" checked="checked"
                onchange="\$('autoinstalllist').value = ''; \$('vmtype-linux-hvm').checked = true">
${cdromList(defaults.cdrom, "$('cd_or_auto_cd').checked = true;$('autoinstalllist').value = '';$('vmtype-linux-hvm').checked = true")}
</td>
	  </input>
	</tr>
	${errorRow('cdrom', err)}
	${errorRow('cdrom', err)}
	<tr>
	  <td>Owner</td>
	  <td><input type="text" name="owner" value="${defaults.owner}"/></td>
	</tr>
	${errorRow('owner', err)}
      </table>
      <input type="submit" class="button" value="Create it!"/><br />
      Windows notes: ${fn.helppopup('Windows')}
    </form>
% endif
</%def>

<%def name="machineRow(machine)">
      <tr> 
	<td rowspan="2">
	  <form action="command" method="post">
	    <input type="hidden" name="back" value="list"/>
	    <input type="hidden" name="machine_id"
		   value="${machine.machine_id}"/>
<input type="submit" class="power ${'on' if machine.uptime else 'off'}" name="action" value="${'Power off' if machine.uptime else 'Power on'}"\
% if machine.uptime:
 onclick="return confirm('Are you sure you want to power off this VM?');"
% endif
/>
	  </form>
	</td>
	<td><a href="info?machine_id=${machine.machine_id}">${machine.name}</a></td>
	<td>${machine.memory}M</td>
	<td>${machine.owner}</td>
	<td>${machine.administrator}</td>
% if machine.nics:
	<td>${', '.join(map(lambda x: x.ip, machine.nics))}</td>
% else:
	<td></td>
% endif
<td>\
% if machine.uptime:
${datetime.timedelta(seconds=int(machine.uptime))}\
% endif
</td>
	<td>\
% if has_vnc[machine] == True:
<a href="vnc?machine_id=${machine.machine_id}">Console</a>\
% elif has_vnc[machine] != 'Off':
${has_vnc[machine]}
% endif
</td>
      </tr>
      <tr>
        <td colspan="7" style="padding-left: 1em; color: #666">${machine.description}</td>
      </tr>
</%def>

<%def name="machineList(machines)">
    <table cellspacing="0" cellpadding="2">
      <tr>
	<th></th>
	<th>Name</th>
	<th>Memory</th>
	<th>Owner${fn.helppopup('Owner')}</th>
        <th>Administrator${fn.helppopup('Administrator')}</th>
	<th>IP</th>
	<th>Uptime</th>
	<th>VNC</th>
      </tr>
% for machine in machines:
	${machineRow(machine)}
% endfor
    </table>
    <script type="text/javascript" src="/static/stripe.js"></script>
    <script type="text/javascript">
        document.observe("dom:loaded", function() {
            stripe(\$('machinelist').getElementsByTagName('table')[0],
                   'stripedrow');
        });
    </script>
</%def>

<p style="font-size: 125%;"><a href="http://${config.web.hostname}">What is XVM?</a></p>
% if not machines:
<p>You don't currently control any VMs.</p>   
% endif
    <p><a href="list">refresh</a></p>
    <div id="machinelist">
    ${machineList(machines)}
    </div>
${createForm()}
