#!/usr/bin/python
"""Main FastCGI entry point for web interface"""

import cherrypy
import os
import sys
from main import InvirtWeb

dev = False
base_dir = os.path.dirname(__file__)

if __name__=="__main__":
    static_dir = os.path.join(base_dir, 'static')

    if len(sys.argv) > 1:
        conf_file = sys.argv[1]
        dev = True
    else:
        conf_file = os.path.join(base_dir, 'main.conf')
    app = cherrypy.tree.mount(InvirtWeb(),
        '/' if dev else '/main.fcgi',
        {'/':      {'tools.staticdir.root': static_dir,
                    'tools.invirtwebstate.on': True},
        '/static': {'tools.staticdir.on': True,
                    'tools.staticdir.dir': static_dir}
         })
    app.merge(conf_file)
    cherrypy.config.update(conf_file)

    if dev:
        cherrypy.server.quickstart()
        cherrypy.engine.start()
        cherrypy.engine.block()
    else:
        cherrypy.engine.start(blocking=False)
        from flup.server.fcgi import WSGIServer
        server = WSGIServer(app)
        server.run()
