# Interface: define variables name, ivversionappend, and function
# hack_package ().

set -e

# Process arguments.
dist_arch=$1; shift
a=
if [ "$1" = "-A" ]; then a=-A; shift; fi
chroot=$dist_arch-sbuild

if [ -z "$dist_arch" -o $# -eq 0 ]; then
    echo 'No arguments!' >&2
    exit 2
fi

dist=$(echo "$dist_arch" | sed 's/^\(.*\)-\([^-]*\)$/\1/')
arch=$(echo "$dist_arch" | sed 's/^\(.*\)-\([^-]*\)$/\2/')
: ${section=invirt-system}
: ${ivname=$name}
: ${release=-proposed}

# Create a chroot and define functions for using it.
sid=$(schroot -b -c "$chroot")
trap 'schroot -e -c "$sid"' EXIT
sch() { schroot -r -c "$sid" -- "$@"; }           # Run in the chroot
schq() { schroot -q -r -c "$sid" -- "$@"; }       # Run in the chroot quietly
schr() { schroot -r -c "$sid" -u root -- "$@"; }  # Run in the chroot as root
schr apt-get -qq -y update || exit 3

quote() {
  echo "$1" | sed 's/[^[:alnum:]]/\\&/g'
}

munge_sections () {
    perl -0pe "s/^Section: /Section: $section\\//gm or die" -i debian/control
}

add_changelog () {
    if [ -n "$dch_done" ]; then
	dch "$@"
    else
	echo | dch -v"${ivversion}" -D unstable "$@"
	dch_done=1
    fi
}

append_description () {
    perl -0pe 'open THREE, "</dev/fd/3"; $x = <THREE>; s/(^Description:.*\n( .*\S.*\n)*)/$1$x/gm or die' -i debian/control 3<&0
}

add_build_depends () {
    perl -0pe 's/^(Build-Depends:.*(?:\n[ \t].*)*)$/$1, '"$1"'/m or die' -i debian/control
}

add_invirt_provides () {
    [ "$name" = "$ivname" ]
    perl -0pe 's/^(Package: (.*)\n(?:(?!Provides:).+\n)*)(?:Provides: (.*)\n((?:.+\n)*))?(?=\n|\z)/$1Provides: $3, invirt-$2\n$4/mg or die; s/^Provides: , /Provides: /mg' -i debian/control
    add_changelog "Provide invirt-$name."
}

rename_source () {
    perl -pe "s{^Source: $name\$}{Source: $ivname}" -i debian/control
    add_changelog "Rename package to $ivname."
    perl -0pe "s/^$name/$ivname/" -i debian/changelog
}

cmd_source () {
    if [ "$a" != "-A" ]; then
	echo "Not building source package for $dist_arch." >&2
	return
    fi
    echo "Building source for $ivname-$ivversion on $dist_arch" >&2
    
    if ! [ -e "${name}_$version.dsc" ]; then
	sch apt-get -d source "$name"
    fi
    
    if ! [ -e "${ivname}_$ivversion.dsc" ]; then
	(
	    tmpdir=$(mktemp -td "invirtify.$$.XXXXXXXXXX")
	    trap 'rm -rf "$tmpdir"' EXIT
	    origversion=$(echo "$version" | sed 's/-[^-]*$//')
	    cp -a "${name}_$origversion.orig.tar.gz" "$tmpdir/"
	    dscdir=$(pwd)
	    cd "$tmpdir/"
	    dpkg-source -x "$dscdir/${name}_$version.dsc" "$tmpdir/$name-$origversion"
	    cd "$tmpdir/$name-$origversion"
	    dch_done=
	    hack_package
            if [ "$name" != "$ivname" ]; then
                rename_source
                cp -a "$tmpdir/${name}_$origversion.orig.tar.gz" "$tmpdir/${ivname}_$origversion.orig.tar.gz"
                cp -a "$tmpdir/${ivname}_$origversion.orig.tar.gz" "$dscdir"
            fi
	    [ -n "$dch_done" ]
	    schr apt-get -q -y install devscripts pbuilder
	    schr /usr/lib/pbuilder/pbuilder-satisfydepends
	    sch debuild -S -sa -us -uc -i -I.svn && cp -a "../${ivname}_$ivversion"* "$dscdir"
	)
	[ $? -eq 0 ] || exit 1
	
	if [ -n "$IV_CHECK_DIFFS" ]; then
	    interdiff -z "${name}_$version.diff.gz" "${ivname}_$ivversion.diff.gz" | \
		enscript --color --language=ansi --highlight=diffu --output=- -q | \
		less -R
	    echo -n "Press Enter to continue: " >&2
	    read dummy
	fi
    fi
}

cmd_binary () {
    sbuildhack "$dist_arch" $a "${ivname}_$ivversion.dsc"
}

v () {
    echo "$@"
    "$@"
}

cmd_upload () {
    if [ "$a" = "-A" ]; then
	v reprepro-env include "${dist}${release}" "${ivname}_${ivversion}_source.changes"
    fi
    v reprepro-env include "${dist}${release}" "${ivname}_${ivversion}_${arch}.changes"
}

version=$(
    sch apt-cache showsrc "$name" | \
	sed -n 's/^Version: \(.*\)$/\1/ p' | (
	version='~~~'
	while read -r newversion; do
	    if [ $(expr "$newversion" : '.*invirt') = 0 ] && \
		dpkg --compare-versions "$newversion" '>' "$version"; then
		version=$newversion
	    fi
	done
	if [ "$version" = '~~~' ]; then
	    echo "No version of $name found." >&2
	    exit 1
	fi
	echo "$version"
	)
    )
ivversion=$version$ivversionappend

# Look for binary packages built from the named package with the right
# version, and exit out if we find one (an architecture-specific one
# if we weren't run with the -A flag).  We need to look for either a
# Source: or a Package: header matching $name since there is no
# Source: header for a package whose name matches its source.
pkgfile="/srv/repository/dists/$dist/$section/binary-$arch/Packages.gz"
if { zcat "$pkgfile" | \
    dpkg-awk -f - "Package:^$ivname\$" "Version:^$(quote "$ivversion")\$" -- Architecture;
    zcat $pkgfiles | \
    dpkg-awk -f - "Source:^$ivname\$" "Version:^$(quote "$ivversion")\$" -- Architecture; } \
    | if [ "$a" = "-A" ]; then cat; else fgrep -vx 'Architecture: all'; fi \
    | grep -q .; then
    echo "$ivname $ivversion already exists for $dist_arch." >&2
    exit 0
fi

for cmd; do
    "cmd_$cmd"
done
