<%
    import yaml
    svn = yaml.load(open('svn.yml'))
    packages = svn['packages']
    trunks = svn['trunks']
    scripts = svn['scripts']
    quashes = svn['quashes']

    repos = ['packages/%s' % package for package in packages]
    repos += ['scripts/%s' % script for script in scripts]
    repos += ['doc/xvm', 'scripts/osx-update']

    for package in packages:
        if 'merge' in packages[package]:
            repos.remove('packages/%s' % package)

    def get_repo(package):
        if 'merge' in packages[package]:
            return get_repo(packages[package]['merge'])
        return 'packages/%s.git' % package

    def get_branch(package):
        if 'branch' in packages[package]:
            return packages[package]['branch']
        if 'merge' in packages[package]:
            return get_branch(packages[package]['merge'])
        return 'master'

    def get_tag_prefix(package):
        if 'merge' in packages[package]:
            return '%s/' % package
        return ''
%>

% for repo in repos:
create repository ${repo}.git
end repository

% endfor

% for quash in quashes:
match ${quash['path']}
  min revision ${quash['rev']}
  max revision ${quash['rev']}
end match
% endfor

% for package in packages:

%   if package == 'sipb-xen-database':
match /trunk/packages/${package}/${package}-0/
  repository ${get_repo(package)}
  branch ${get_branch(package)}
  max revision 8
end match
%   endif

%   if 'undouble' in packages[package]:
match /trunk/packages/${package}/${package}/
  repository ${get_repo(package)}
  branch ${get_branch(package)}
  max revision ${packages[package]['undouble'][0] - 1}
end match

match /package_tags/${package}/([^/~]+)/${package}/
  repository ${get_repo(package)}
  branch tags/${get_tag_prefix(package)}\1
  max revision ${packages[package]['undouble'][0] - 1}
end match

match /trunk/packages/tmp/${package}/
  min revision ${packages[package]['undouble'][0]}
  max revision ${packages[package]['undouble'][0]}
end match

match /trunk/packages/${package}/
  min revision ${packages[package]['undouble'][1]}
  max revision ${packages[package]['undouble'][1]}
end match
%   endif

match /trunk/packages/${package}/
  repository ${get_repo(package)}
  branch ${get_branch(package)}
%   if 'undouble' in packages[package]:
  min revision ${packages[package]['undouble'][1] + 1}
%   endif
%   if 'punt' in packages[package]:
  max revision ${packages[package]['punt'] - 1}
%   endif
end match

match /package_tags/${package}/([^/~]+)/
  repository ${get_repo(package)}
  branch tags/${get_tag_prefix(package)}\1
%   if 'undouble' in packages[package]:
  min revision ${packages[package]['undouble'][1]}
%   endif
end match

match /package_tags/${package}/([^/~]+)~([^/~]+)/
  repository ${get_repo(package)}
  branch tags/${get_tag_prefix(package)}\1_\2
%   if 'undouble' in packages[package]:
  min revision ${packages[package]['undouble'][1]}
%   endif
end match

% endfor

match /trunk/packages/(xen-common|xen-3.1)/
end match

match /package_tags/(xen-common|xen-3.1)/
end match

% for trunk in trunks:
%   if 'inclusive' in trunks[trunk]:
match /trunk/${trunk}(/|$)
%   else:
match /trunk/${trunk}/
%   endif
  repository ${get_repo(trunks[trunk]['merge'])}
%   if 'branch' in trunks[trunk]:
  branch ${trunks[trunk]['branch']}
%   else:
  branch ${get_branch(trunks[trunk]['merge'])}
%   endif
%   if 'inclusive' in trunks[trunk]:
  max revision ${trunks[trunk]['punt']}
%   else:
  max revision ${trunks[trunk]['punt'] - 1}
%   endif
end match
% endfor

match /trunk/vnc/tightvnc-1.3.9_javasrc.zip
end match

% for script in scripts:
match /trunk/scripts/${script}/
  repository scripts/${script}.git
  branch master
end match
% endfor

match /trunk/scripts/
  repository scripts/osx-update.git
  branch master
  min revision 1785
  max revision 1785
end match

match /trunk/scripts/
  repository scripts/install-invirt.git
  branch master
  min revision 2026
  max revision 2026
end match

match /trunk/scripts/
  repository scripts/prod-migration.git
  branch master
  max revision 1863
end match

% for rev in [803, 804, 925, 926, 928, 1537, 1566]:
match /trunk/
  repository doc/xvm.git
  branch master
  min revision ${rev}
  max revision ${rev}
end match
% endfor

match /trunk/vmctl/
end match

match /trunk/COPYING$
end match

match /branches/wsgi/
end match
