#!/usr/bin/env python

import sys
import os
from subprocess import call

def make_debian_cd(basetree, guest_ip, guest_hostname, passhash, output_iso):
  old_preseed = file(os.path.join(basetree, 'preseed.cfg'))
  cdtree = os.path.join(basetree, 'cdrom')
  new_preseed = file(os.path.join(cdtree, 'preseed.cfg'), 'w')
  new_preseed.write(old_preseed.read())
  new_preseed.write('d-i netcfg/get_ipaddress string '+guest_ip+'\n')
  new_preseed.write('d-i netcfg/get_hostname string '+guest_hostname+'\n')
  new_preseed.write('d-i passwd/root-password-crypted password '+passhash+'\n')
  new_preseed.close()
  call('''mkisofs -r -V "SIPB-Xen_Custom_Install_CD" -cache-inodes -J -l
           -b isolinux/isolinux.bin -c isolinux/boot.cat
           -no-emul-boot -boot-load-size 4 -boot-info-table'''.split()
       + ['-o', output_iso, cdtree])

if __name__ == '__main__':
  make_debian_cd(*sys.argv[1:])
