# For a package which only configures another, "parent" package.
#
# Global variable PARENTPACKAGE names parent; unset for no parent,
# array for (zero or one or) many parents.
#
# Global variable PACKAGE names this package, for log message.
#
# If BASH_VERSION is null or unset, accepts only one parent in
# PARENTPACKAGE, or empty for zero.

. /lib/init/vars.sh
. /lib/lsb/init-functions
. /lib/init/gen-files.sh

if [ $BASH_VERSION ]; then
  handle_parents () {
    for p in "${PARENTPACKAGE[@]}"; do
      invoke-rc.d "$p" "$1"
    done
  }
else
  handle_parents () {
    if [ -n "$PARENTPACKAGE" ]; then
      invoke-rc.d "$PARENTPACKAGE" "$1"
    fi
  }
fi

config_init () {
  case "$1" in
    start|reload|force-reload|restart)
      log_begin_msg "Reloading config for $PACKAGE"
      gen_files
      log_end_msg $?
      handle_parents "$1"
      ;;
    stop)
      handle_parents "$1"
      ;;
    *)
      log_success_msg "Usage: /etc/init.d/$PACKAGE {start|reload|force-reload|restart|stop}"
      ;;
  esac
}
