<%
    packages = [line.strip() for line in open('package-list')]
    packages.append('packages/xvm-console-devconfig')
    repos = packages
    packages = [package[len('packages/'):] for package in packages]

    doubled_packages = {
        'sipb-xen-base': (314, 315),
        'sipb-xen-database': (311, 313),
        'sipb-xen-dev': (314, 315),
        'sipb-xen-dom0': (314, 315),
        'sipb-xen-remctl-auto': (314, 315),
    }

    punt = {
        'sipb-xen-guest-installer': 742,
        'sipb-xen-dns': 1184,
        'sipb-xen-base': 1350,
        'sipb-xen-chrony-config': 1351,
        'sipb-xen-database': 1352,
        'sipb-xen-dev': 1353,
        'sipb-xen-dom0': 1354,
        'sipb-xen-host-master': 1355,
        'sipb-xen-iptables': 1356,
        'sipb-xen-python-pydhcplib': 1357,
        'sipb-xen-remctl-auto': 1358,
        'sipb-xen-vnc-client': 1359,
        'sipb-xen-www': 1360,
        'sipb-xen-vnc-server': 1387,
        'sipb-xen-dhcp': 1436,
        'sipb-xen-autoinstaller': 1569,
        'sipb-xen-clvm-config': 1569,
        'invirt-console-host': 1816,
        'invirt-console-server': 1816,
    }

    merges = []
    for line in open('merges'):
        line = line.strip()
        if line == '' or line[0] == '#':
            continue

        merges.append(line.split())

    merge_map = {}
    merge_count = {}
    merge_n = {}
    for merge in merges:
        repos.remove('packages/%s' % merge[0])
        merge_map[merge[0]] = merge[1]
        if int(merge[2]) == 0:
            merge_count[merge[1]] = merge_count.get(merge[1], 0) + 1
        else:
            merge_n[merge[0]] = int(merge[2])

    def get_repo(package):
        if package in merge_map:
            return get_repo(merge_map[package])
        return 'packages/%s.git' % package

    def get_branch(package):
        if package in merge_map:
            if package in merge_n or merge_count[merge_map[package]] > 1:
                return package
            return get_branch(merge_map[package])
        return 'master'

    def get_tag_prefix(package):
        if package in merge_map:
            return '%s/' % package
        return ''
%>

% for repo in repos:
create repository ${repo}.git
end repository

% endfor

match /package_tags/sipb-xen-dev/sipb-xen-dev(/|$)
end match

match /trunk/packages/sipb-xen-autoinstaller(/|$)
  min revision 742
  max revision 742
end match

% for package in packages:

% if package == 'sipb-xen-database':
match /trunk/packages/${package}/${package}-0(/|$)
  repository ${get_repo(package)}
  branch ${get_branch(package)}
  max revision 8
end match
% endif

% if package in doubled_packages:
match /trunk/packages/${package}/${package}(/|$)
  repository ${get_repo(package)}
  branch ${get_branch(package)}
  max revision ${doubled_packages[package][0] - 1}
end match

match /package_tags/${package}/([^/~]+)/${package}(/|$)
  repository ${get_repo(package)}
  branch tags/${get_tag_prefix(package)}\1
  max revision ${doubled_packages[package][0] - 1}
end match

match /trunk/packages/tmp/${package}(/|$)
  repository ${get_repo(package)}
  branch ${get_branch(package)}
  max revision ${doubled_packages[package][1] - 1}
end match
% endif

match /trunk/packages/${package}(/|$)
  repository ${get_repo(package)}
  branch ${get_branch(package)}
% if package in doubled_packages:
  min revision ${doubled_packages[package][1]}
% endif
% if package in punt:
  max revision ${punt[package] - 1}
% endif
end match

match /package_tags/${package}/([^/~]+)(/|$)
  repository ${get_repo(package)}
  branch tags/${get_tag_prefix(package)}\1
% if package in doubled_packages:
  min revision ${doubled_packages[package][1]}
% endif
end match

match /package_tags/${package}/([^/~]+)~([^/~]+)(/|$)
  repository ${get_repo(package)}
  branch tags/${get_tag_prefix(package)}\1_\2
% if package in doubled_packages:
  min revision ${doubled_packages[package][1]}
% endif
end match

% endfor

match /trunk/packages/(xen-common|xen-3.1)(/|$)
end match

match /package_tags/(xen-common|xen-3.1)(/|$)
end match

match /trunk/dhcp(/|$)
  repository ${get_repo('sipb-xen-dhcp')}
  branch ${get_branch('sipb-xen-dhcp')}
  max revision 281
end match

match /trunk/web(/|$)
  repository ${get_repo('sipb-xen-www')}
  branch ${get_branch('sipb-xen-www')}
  max revision 302
end match

match /trunk/vnc/tightvnc-1.3.9_javasrc.zip
end match

match /trunk/vnc/vnc_javasrc(/|$)
  repository ${get_repo('sipb-xen-vnc-client')}
  branch ${get_branch('sipb-xen-vnc-client')}
end match

match /trunk/vnc/vnc_server(/|$)
  repository ${get_repo('sipb-xen-vnc-server')}
  branch ${get_branch('sipb-xen-vnc-server')}
end match

match /trunk/(dns|scripts|vmctl)(/|$)
end match

match /trunk/(COPYING|xvm-host-setup-notes)
end match

match /branches/wsgi(/|$)
end match
