<%
    packages = [line.strip() for line in open('package-list')]
    packages.append('packages/xvm-console-devconfig')
    repos = packages
    packages = [package[len('packages/'):] for package in packages]

    merges = []
    for line in open('merges'):
        line = line.strip()
        if line == '' or line[0] == '#':
            continue

        merges.append(line.split())

    merge_map = {}
    merge_count = {}
    merge_n = {}
    for merge in merges:
        repos.remove('packages/%s' % merge[0])
        merge_map[merge[0]] = merge[1]
        if int(merge[2]) == 0:
            merge_count[merge[1]] = merge_count.get(merge[1], 0) + 1
        else:
            merge_n[merge[0]] = int(merge[2])

    def get_repo(package):
        if package in merge_map:
            return get_repo(merge_map[package])
        return 'packages/%s.git' % package

    def get_branch(package):
        if package in merge_map:
            if package in merge_n or merge_count[merge_map[package]] > 1:
                return package
            return get_branch(merge_map[package])
        return 'master'

    def get_tag_prefix(package):
        if package in merge_map:
            return '%s/' % package
        return ''
%>

% for repo in repos:
create repository ${repo}.git
end repository

% endfor

match /package_tags/sipb-xen-dev/sipb-xen-dev/
end match

% for package in packages:
match /trunk/packages/${package}/${package}/
  repository ${get_repo(package)}
  branch ${get_branch(package)}
end match

match /package_tags/${package}/([^/~]+)/${package}/
  repository ${get_repo(package)}
  branch tags/${get_tag_prefix(package)}\1
end match

match /trunk/packages/${package}/
  repository ${get_repo(package)}
  branch ${get_branch(package)}
end match

match /package_tags/${package}/([^/~]+)/
  repository ${get_repo(package)}
  branch tags/${get_tag_prefix(package)}\1
end match

match /package_tags/${package}/([^/~]+)~([^/~]+)/
  repository ${get_repo(package)}
  branch tags/${get_tag_prefix(package)}\1_\2
end match

% endfor

match /trunk/packages/(xen-common|xen-3.1)/
end match

match /package_tags/(xen-common|xen-3.1)/
end match

match /trunk/packages/tmp/
  repository ${get_repo('sipb-xen-database')}
  branch ${get_branch('sipb-xen-database')}
end match

match /trunk/(dhcp|dns|scripts|vnc|web|vmctl)/
end match

match /trunk/(COPYING|xvm-host-setup-notes)
end match

match /branches/wsgi/
end match
