"""
Functions to perform remctls.
"""

from invirt.common import CodeError
import subprocess

def kinit():
    """Kinit with a given username and keytab"""
    p = subprocess.Popen(['kinit', "-k", "-t", '/etc/invirt/keytab',
                          'daemon/'+config.web.hostname],
                         stderr=subprocess.PIPE)
    e = p.wait()
    if e:
        raise CodeError("Error %s in kinit: %s" % (e, p.stderr.read()))

def checkKinit():
    """If we lack tickets, kinit."""
    p = subprocess.Popen(['klist', '-s'])
    if p.wait():
        kinit()

def remctl(*args, **kws):
    """Perform a remctl and return the output.

    kinits if necessary, and outputs errors to stderr.
    """
    checkKinit()
    p = subprocess.Popen(['remctl', config.remote.hostname]
                         + list(args),
                         stdout=subprocess.PIPE,
                         stderr=subprocess.PIPE)
    v = p.wait()
    if kws.get('err'):
        return p.stdout.read(), p.stderr.read()
    if v:
        print >> sys.stderr, 'Error', v, 'on remctl', args, ':'
        print >> sys.stderr, p.stderr.read()
        raise CodeError('ERROR on remctl')
    return p.stdout.read()
