from sqlalchemy import *

meta = DynamicMetaData()

machine_table = Table('machines', meta,
       Column('machine_id', Integer, primary_key=True, nullable=False),
       Column('name', String, nullable=False),
       Column('memory', Integer, nullable=False),
       Column('owner', String, nullable=False),
       Column('contact', String, nullable=False),
       Column('uuid', String, nullable=False),
       Column('boot_off_cd', Boolean, nullable=False, default=False),
       Column('type_id', String, ForeignKey('types.type_id'), nullable=False),
       Column('autorestart', Boolean, nullable=False, default=False),
       Column('cpus', Integer, nullable=False, default=1))

nic_table = Table('nics', meta,
       Column('machine_id', Integer, ForeignKey('machines.machine_id'), nullable=True),
       Column('mac_addr', String, nullable=False),
       Column('hostname', String, nullable=False))

disk_table = Table('disks', meta,
       Column('machine_id', Integer, ForeignKey('machines.machine_id'), nullable=False),
       Column('guest_device_name', String, nullable=False),
       Column('size', Integer, nullable=False),
       PrimaryKeyConstraint('machine_id', 'guest_device_name'))

types_table = Table('types', meta,
       Column('type_id', String, primary_key=True, nullable=False),
       Column('description', String, nullable=False),
       Column('apic', Boolean, nullable=False),
       Column('acpi', Boolean, nullable=False),
       Column('pae', Boolean, nullable=False))

