#!/usr/bin/python

import os
from debian_bundle.changelog import Changelog
from debian_bundle.deb822 import Deb822
from email.utils import parseaddr
from setuptools import setup

version = Changelog(open(os.path.join(__file__, 'debian/changelog')).read()).\
    get_version().full_version

maintainer_full = Deb822(open(os.path.join(__file__, 'debian/control')))['Maintainer']
maintainer, maintainer_email = parseaddr(maintainer_full)

setup(
    name='invirt',
    version=version,
    maintainer=maintainer,
    maintainer_email=maintainer_full,
    
    package_dir = {'': 'python'},
    scripts=['scripts/invirt-getconf', 'scripts/invirt-reload']
)
