<%
from invirt.config import structs as cfg
hostname = cfg.web.hostname
errmail  = cfg.web.errormail
tracuri  = cfg.trac.uri
%>
Listen 443
Listen 446

<VirtualHost *:443>
	ServerAdmin ${errmail}
	ServerName ${hostname}:443
	
	DocumentRoot /var/www/sipb-xen-www
	<Directory /var/www/sipb-xen-www>
		Options Indexes FollowSymLinks MultiViews ExecCGI
		AllowOverride None
		Order allow,deny
		allow from all
	</Directory>
	<Location />
		Require valid-user
		AuthType SSLCert
		AuthSSLCertVar SSL_CLIENT_S_DN_Email
		AuthSSLCertStripSuffix "@MIT.EDU"
	</Location>

	RewriteEngine On
	RewriteRule ^/favicon.ico - [L]
	RewriteRule ^/static(.*) - [L]
	RewriteRule ^/overlord/static(.*) /static/$1 [L]
	RewriteRule ^/admin/static(.*) /static/$1 [L]
	RewriteRule ^/trac.fcgi(.*) - [L]
	RewriteRule ^/trac/chrome/common(.*) /usr/share/trac/htdocs$1 [L]
	RewriteRule ^/trac(.*) /var/www/trac/trac.fcgi$1 [L]
	RewriteRule ^/var(.*) - [L]
	RewriteRule ^/wiki(.*) - [L]
	RewriteRule ^/kill.cgi - [L]
	RewriteRule ^/~ - [L]
	RewriteRule ^/(.*) /var/www/sipb-xen-www/main.fcgi/$1 [L]

	RewriteLog /var/log/apache2/rewrite.log
	RewriteLogLevel 0 

	ErrorLog /var/log/apache2/error.log

	# Possible values include: debug, info, notice, warn, error, crit,
	# alert, emerg.
	LogLevel warn

	CustomLog /var/log/apache2/ssl_access.log combined
	ServerSignature On

	SSLEngine on

	SSLCertificateFile ssl/server.crt
	SSLCertificateKeyFile ssl/server.key
	
	SSLCACertificateFile ssl/mitCAclient.pem
	SSLVerifyClient require
	SSLVerifyDepth 10

	SSLOptions +StdEnvVars
	
	SetEnvIf User-Agent ".*MSIE.*" nokeepalive ssl-unclean-shutdown downgrade-1.0 force-response-1.0

	Redirect /wiki ${tracuri}	
</VirtualHost>

<VirtualHost *:446>
	ServerAdmin ${errmail}
	ServerName ${hostname}:446
	
	DocumentRoot /var/www/sipb-xen-www
	<Directory />
		Options Indexes FollowSymLinks MultiViews ExecCGI
		AllowOverride None
		Order allow,deny
		allow from all
	</Directory>

	ErrorLog /var/log/apache2/error.log

	# Possible values include: debug, info, notice, warn, error, crit,
	# alert, emerg.
	LogLevel warn

	CustomLog /var/log/apache2/ssl_nocert_access.log combined
	ServerSignature On

	SSLEngine on

	SSLCertificateFile ssl/server.crt
	SSLCertificateKeyFile ssl/server.key
	
	SSLVerifyClient none

	SSLOptions +StdEnvVars
	
	SetEnvIf User-Agent ".*MSIE.*" nokeepalive ssl-unclean-shutdown downgrade-1.0 force-response-1.0	
</VirtualHost>
