#!/usr/bin/python
from sipb_xen_database import *
import sys
import getafsgroups
import subprocess

def expandLocker(name):
    groups = getafsgroups.getLockerAcl(name)
    cell = getafsgroups.getCell(name)
    ans = set()
    for group in groups:
        if ':' in group:
            ans.update(getafsgroups.getAfsGroupMembers(group, cell))
        else:
            ans.add(group)
    return ans

def isUser(name):
    p = subprocess.Popen(['vos', 'examine', 'user.'+name],
                         stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    if p.wait():
        return False
    return True
    

def expandName(name):
    if ':' not in name:
        if isUser(name):
            return [name]
        return []
    try:
        return getafsgroups.getAfsGroupMembers(name, 'athena.mit.edu')
    except getafsgroups.AfsProcessError:
        return []

def accessList(m):
    people = set()
    people.update(expandLocker(m.owner))
    people.update(expandName(m.administrator))
    return people

def refreshMachine(m):
    people = accessList(m)
    old_people = set(a.user for a in m.acl)
    for removed in old_people - people:
        ma = [x for x in m.acl if x.user == removed][0]
        ctx.current.delete(ma)
    for p in people - old_people:
        ma = MachineAccess(user=p)
        m.acl.append(ma)
        ctx.current.save(ma)
    
def refreshCache():
    transaction = ctx.current.create_transaction()

    try:
        machines = Machine.select()
        for m in machines:
            refreshMachine(m)
        ctx.current.flush()
            
        # Atomically execute our changes
        transaction.commit()
    except:
        # Failed! Rollback all the changes.
        transaction.rollback()
        raise

if __name__ == '__main__':
    connect('postgres://sipb-xen@sipb-xen-dev/sipb_xen')
    refreshCache()
