# Anemon Dhcp
# Copyright (C) 2005 Mathieu Ignacio -- mignacio@april.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
"""

"""

import pydhcplib
from pydhcplib.dhcp_packet import *
from anemon.server.dhcp_backend import *
from anemon.server.event_logger import Log


class DhcpServer(pydhcplib.dhcp_network.DhcpServer):
    def __init__(self, reservation_backend,options = {'client_listenport':68,'server_listenport':67}):
        pydhcplib.dhcp_network.DhcpServer.__init__(self,"0.0.0.0",options["client_listen_port"],options["server_listen_port"],)
        self.reservation = reservation_backend
        Log.Output(Log.debug, "__init__ DhcpServer")

    def SendPacket(self, packet):
    	"""Encode and send the packet."""
        
        giaddr = packet.GetOption('giaddr')

        # in all case, if giaddr is set, send packet to relay_agent
        # network address defines by giaddr
        if giaddr!=[0,0,0,0] :
            agent_ip = ".".join(map(str,giaddr))
            self.SendDhcpPacketTo(agent_ip,packet)
            Log.Output(Log.debug, "SendPacket to agent : "+agent_ip)

        # FIXME: This shouldn't broadcast if it has an IP address to send
        # it to instead. See RFC2131 part 4.1 for full details
        else :
            Log.Output(Log.debug, "No agent, broadcast packet.")
            self.SendDhcpPacketTo("255.255.255.255",packet)
            

    def HandleDhcpDiscover(self, packet):
        """Build and send DHCPOFFER packet in response to DHCPDISCOVER
        packet."""

        logmsg = "Get DHCPDISCOVER packet from " + hwmac(packet.GetHardwareAddress()).str()

        Log.Output(Log.info, logmsg)
        offer = DhcpPacket()
        offer.CreateDhcpOfferPacketFrom(packet)
        
        if self.reservation.Query(offer) :
            self.SendPacket(offer)
        # FIXME : what if false ?


    def HandleDhcpRequest(self, packet):
        """Build and send DHCPACK or DHCPNACK packet in response to
        DHCPREQUEST packet. 4 types of DHCPREQUEST exists."""

        ip = packet.GetOption("request_ip_address")
        sid = packet.GetOption("server_identifier")
        ciaddr = packet.GetOption("ciaddr")

        if sid != [0,0,0,0] and ciaddr == [0,0,0,0] :
            Log.Output(Log.info, "Get DHCPREQUEST_SELECTING_STATE packet")

        elif sid == [0,0,0,0] and ciaddr == [0,0,0,0] and ip :
            Log.Output(Log.info, "Get DHCPREQUEST_INITREBOOT_STATE packet")

        elif sid == [0,0,0,0] and ciaddr != [0,0,0,0] and not ip :
            Log.Output(Log.info,"Get DHCPREQUEST_INITREBOOT_STATE packet")

        else : Log.Output(Log.info,"Get DHCPREQUEST_UNKNOWN_STATE packet : not implemented")

        if self.reservation.Lock(packet) : packet.TransformToDhcpAckPacket()
        else : packet.TransformToDhcpNackPacket()

        self.SendPacket(packet)



    # FIXME: These are not yet implemented.
    def HandleDhcpDecline(self, packet):
        Log.Output(Log.info, "Get DHCPDECLINE packet")
        self.reservation.Decline(packet)
        
    def HandleDhcpRelease(self, packet):
        Log.Output(Log.info,"Get DHCPRELEASE packet")
        self.reservation.Unlock(packet)
        
    def HandleDhcpInform(self, packet):
        Log.Output(Log.info, "Get DHCPINFORM packet")

        if self.reservation.Lock(packet) :
            packet.TransformToDhcpAckPacket()
            # FIXME : Remove lease_time from options
            self.SendPacket(packet)

        # FIXME : what if false ?
