from pydhcplib import dhcp_constants
from pydhcplib.type_ipv4 import ipv4
from anemon.server import db_classes
from anemon.server import plugins_loader
from datetime import datetime, timedelta
from sqlobject import *



def init() :
	global SelectSingleHostScopes,SelectMultipleHostScopes
	global SelectSingleHostByChaddrAndIdentifier
	global SelectSingleHostByICI,SelectIpFromHostByIpaddr
	global SelectIpFromHostByChaddr,SelectIpFromHostByIdentifier
	global GetOptionsFromRange,InsertLease,DeleteLease,UpdateLeaseTime
	global UpdateLeaseState,SelectLeaseByChaddrAndIdentifier,SearchLease

	def SelectSingleHostScopes() :
		""" Return all ip of single host scope definitions."""
		data = list(db_classes.Scopes.select(db_classes.Scopes.q.first==db_classes.Scopes.q.last))
		return data

	def SelectMultipleHostScopes() :
		""" Return all range definition for range definitions."""
		data = list(db_classes.Scopes.select(db_classes.Scopes.q.first!=db_classes.Scopes.q.last))
		return data

	def SelectSingleHostByChaddrAndIdentifier(_chaddr,_identifier) :
		return list(db_classes.Scopes.selectBy(db_classes.Scopes.q.first==db_classes.Scopes.q.last,
						       db_classes.Scopes.q.identifier==_identifier.str(),
						       db_classes.Scopes.q.chaddr==_chaddr.str()))
	
	def SelectSingleHostByICI(_ipaddr,_chaddr,_identifier) :
		query = AND(db_classes.Scopes.q.first==db_classes.Scopes.q.last,
			    db_classes.Scopes.q.identifier==_identifier.str(),
			    db_classes.Scopes.q.chaddr==_chaddr.str(),
			    db_classes.Scopes.q.first==_ipaddr.str())
		return list(db_classes.Scopes.select(query))



	
	def SelectIpFromHostByIpaddr(ipaddr) :
		""" Return ipv4 type ip. """
		query = AND(db_classes.Scopes.q.first==db_classes.Scopes.q.last,db_classes.Scopes.q.ipaddr==ipaddr.str())
		data = list(db_classes.Scopes.select(query))
		if ( len(data) > 0 ) : return ipv4(data[0].first)
		return None
		

	def SelectIpFromHostByChaddr(hwmac) :
		""" Return ipv4 type ip. """
		query = AND(db_classes.Scopes.q.first==db_classes.Scopes.q.last,db_classes.Scopes.q.chaddr==hwmac.str())
		data = list(db_classes.Scopes.select(query))
		if ( len(data) > 0 ) : return ipv4(data[0].first)
		return None

	def SelectIpFromHostByIdentifier(clientid) :
		""" Return ipv4 type ip. """
		query = AND(db_classes.Scopes.q.first==db_classes.Scopes.q.last,db_classes.Scopes.q.identifier==clientid.str())
		data = list(db_classes.Scopes.select(query))
		if ( len(data) > 0 ) : return ipv4(data[0].first)
		return None




	def GetOptionsFromRange(ipv4_first,ipv4_last) :
		query = AND(OR(db_classes.Options.q.name==db_classes.Scopes.q.name,
			       db_classes.Options.q.name==db_classes.Scopes.q.subnet),
			    db_classes.Scopes.q.first==ipv4_first.str(),db_classes.Scopes.q.last==ipv4_last.str())
		return list(db_classes.Options.select(query))




	"""
	Lease database specific functions
	"""


	def InsertLease(_server,_ipaddr,_chaddr,_identifier,_leasetime):
		local_lease = db_classes.Leases(server=_server,ipaddr=_ipaddr,chaddr=_chaddr,
						identifier=_identifier,
						stime=datetime.today(),
						etime=(datetime.today()+timedelta(seconds=_leasetime)))
		plugins_loader.NewActiveLease(local_lease)
		return local_lease

	def DeleteLease(_ipaddr,_chaddr,_identifier):
		query = AND(db_classes.Leases.q.chaddr==_chaddr , db_classes.Leases.q.ipaddr==_ipaddr)
		for each in  list(db_classes.Leases.select(query)):
			plugins_loader.BeforeStateChangesToDeleted(each)
			each.delete()
			plugins_loader.AfterStateChangesToDeleted(each)
		
	
	def UpdateLeaseTime(_ipaddr,_chaddr,_identifier,_leasetime):
		query = AND(db_classes.Leases.q.chaddr==_chaddr , db_classes.Leases.q.ipaddr==_ipaddr)
		for each in  list(db_classes.Leases.select(query)) :
			plugins_loader.BeforeRenewActiveLease(each)
			each.set(stime=datetime.today(),etime=(datetime.today()+timedelta(seconds=_leasetime)))
			plugins_loader.AfterRenewActiveLease(each)


		
	def UpdateLeaseState():
		# 1- Delete Released leases.
		for each in list(db_classes.Leases.select(db_classes.Leases.q.state=="released")) :
			plugins_loader.BeforeStateChangesToDeleted(each)
			each.delete()
			plugins_loader.AfterStateChangesToDeleted(each)

			
		# 2- Delete Abandoned leases.
		for each in  list(db_classes.Leases.select(db_classes.Leases.q.state=="abandoned")) :
			plugins_loader.BeforeStateChangesToDeleted(each)
			each.delete()
			plugins_loader.AfterStateChangesToDeleted(each)


		# 3- Mark all Expired leases as "Occupied"
		for each in  list(db_classes.Leases.select(db_classes.Leases.q.state=="expired")) :
			
			plugins_loader.BeforeStateChangesToOccupied(each)
			each.set(state="occupied")
			plugins_loader.AfterStateChangesToOccupied(each)
		
		# 4- Set too old Active leases to Expired state
		query = AND(db_classes.Leases.q.state == "active",
			    db_classes.Leases.q.etime >= datetime.today())
		for each in  list(db_classes.Leases.select(query)) :
			plugins_loader.BeforeStateChangesToExpired(each)
			each.set(state="expired")
			plugins_loader.AfterStateChangesToExpired(each)

		# 5- To Do (states changes to "released" and "abandoned")


	def SelectLeaseByChaddrAndIdentifier(_chaddr,_identifier):
		query = AND(db_classes.Leases.q.chaddr==_chaddr , db_classes.Leases.q.identifier==_identifier)
		return list(db_classes.Leases.select(query))

	
	def SearchLease(_ipaddr,_chaddr,_identifier) :
		query = AND(db_classes.Leases.q.chaddr==_chaddr , db_classes.Leases.q.ipaddr==_ipaddr)
		for each in  list(db_classes.Leases.select(query)) :
			each.set(stime=datetime.today(),etime=(datetime.today()+timedelta(_leasetime)))
		
