# Anemon Dhcp
# Copyright (C) 2005 Mathieu Ignacio -- mignacio@april.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

from pydhcplib.type_ipv4 import ipv4
from pydhcplib.type_hw_addr import hwmac
from pydhcplib.type_strlist import strlist
from anemon.server.event_logger import Log


class DhcpBackend:
    def __init__(self,DB) :
        self.database = DB
        Log.Output(Log.debug,"__init__ DhcpBackend")
        
    def Query(self,packet) :
        Log.Output(Log.debug,"dhcp_backend : Query ")

        ip = self.database.GetFreeIp(packet)
        if (not ip) :
            Log.Output(Log.debug,"dhcp_backend : Query result = no ip available")
            return False

        Log.Output(Log.debug,"dhcp_backend : Query result = "+ip[0].str())
        
        packet_parameters = self.database.GetHostParameters(ip[1],ip[2])

        if not packet_parameters : Log.Output(Log.warn,"No parameters available for "+ip[0].str())
        packet_parameters["yiaddr"] = ip[0].list()
        packet.SetMultipleOptions(packet_parameters)

        return True



    def Lock(self,packet) :
        Log.Output(Log.debug, "dhcp_backend : Lock")

        query = self.Query(packet)
        chaddr = hwmac(packet.GetHardwareAddress())
        request = packet.GetOption("request_ip_address")
        yiaddr = packet.GetOption("yiaddr")

        
        if not query :
            Log.Output(Log.info,"No ip available for "+str(chaddr))
            return False

        if yiaddr!="0.0.0.0" and yiaddr == request :
            if self.database.LeaseLock(packet) :
                Log.Output(Log.info,"Lock ip "+str(yiaddr)+" for "+str(chaddr))
                return True
            else : Log.Output(Log.info,"Cannot Lock ip "+str(yiaddr)+" for "+str(chaddr))
        else : Log.Output(Log.info,"Requested ip "+str(request)+" no more available for "+str(chaddr))

        return False

    
    def Unlock(self,packet) :
        Log.Output(Log.debug, "dhcp_backend : Unlock")

        ip = ipv4(packet.GetOption("ciaddr"))
        tmp =  self.database.LeaseUnlock(packet)
        if tmp : Log.Output(Log.warn,"Unlock ip : "+ip.str())
        else : Log.Output(Log.warn,"Cannot unlock ip : "+ip.str())

        return tmp

