# Anemon Dhcp
# Copyright (C) 2005 Mathieu Ignacio -- mignacio@april.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA

from pydhcplib.type_ipv4 import ipv4

class ipv4subnet:
    def __init__(self,value="0.0.0.0/32"):
        """ First option must be a subnet ip like : 192.168.0.0/24 """
        tmp = value.split('/')
        self._ip = ipv4(tmp[0])
        if len(tmp)==2 : self._shortmask = int(tmp[1])
        else : self._shortmask=32

        if self._shortmask < 32 : # multiple host mask
            self._netmask = (0xFFFFFFFF << (32-self._shortmask)) & 0xFFFFFFFF
            self._wildcard = ~self._netmask
            self._network = self._ip.int() & self._netmask
            self._hostmin = self._network + 1
            self._hostmax = (self._network | self._wildcard) - 1
        elif self._shortmask >= 32 : # single host mask
            self._netmask = 0xFFFFFFFF
            self._wildcard = 0x00000000
            self._network = self._ip.int()
            self._hostmin = self._ip.int()
            self._hostmax = self._ip.int()

        self._ip = self._network


    def str(self) :
        return ipv4(self._ip).str()+"/"+str(self._shortmask)

    def __repr__(self) :
        return ipv4(self._ip).str()+"/"+str(self._shortmask)

    
    def IsIpInNetwork(self,ipv4_ip) :
        if ipv4_ip.int()>= self._hostmin and ipv4_ip.int()<= self._hostmax : return True
        return False


    def GetNextIp(self) :
        ip_next = self._ip + 1
        if (not self.IsIpInNetwork(ip_next)) : return False
        self._ip = ip_next
        return self._ip



