# Anemon Dhcp
# Copyright (C) 2005 Mathieu Ignacio -- mignacio@april.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA


from pydhcplib.type_ipv4 import ipv4

class ipv4range:
    def __init__(self,ipv4_first,ipv4_last) :
        if type(ipv4_first) == str : ipv4_first = ipv4(ipv4_first)
        if type(ipv4_first) == int : ipv4_first = ipv4(ipv4_first)
        if type(ipv4_last) == str : ipv4_last = ipv4(ipv4_last)
        if type(ipv4_last) == int : ipv4_last = ipv4(ipv4_last)

        if ipv4_first.int() <= ipv4_last.int() :
            self._ip_1 = ipv4_first
            self._ip_2 = ipv4_last
        else :
            self._ip_1 = ipv4_last
            self._ip_2 = ipv4_first
        self._ip = self._ip_1


    def str(self) :
        return self._ip_1.str()+" "+self._ip_2.str()

    def __repr__(self) :
        return self._ip_1.str()+" "+self._ip_2.str()

    
    def IsIpInNetwork(self,ipv4_ip) :
        if ipv4_ip.int()>=self._ip_1.int() and ipv4_ip.int()<=self._ip_2.int() : return True
        return False


    def GetNextIp(self) :
        ip_next = self._ip
        if (not self.IsIpInNetwork(ip_next)) : return False
        self._ip = ipv4(ip_next.int() + 1)
        return ip_next



