#!/usr/bin/python

from invirt.config import structs as config
import yaml
import gzip
import sys
from subprocess import Popen, PIPE

logfile = sys.argv[1]
hostname = sys.argv[2]

log = yaml.load(gzip.GzipFile(logfile))
current = yaml.load(Popen(['remctl', config.remote.hostname, 'web', 'listvms'],
                     stdout=PIPE).communicate()[0])

was_running_cd = set([k for k,v in log.iteritems() if v['host'] == hostname and 'cdrom' in v])
was_running = set([k for k,v in log.iteritems() if v['host'] == hostname and 'cdrom' not in v])
is_running = set(current.keys())

to_be_booted = was_running - is_running
already_booted = was_running & is_running

print "The following VMs were already rebooted by their owners:"
print "\n".join(sorted(already_booted))

print "\nThe following VMs were booted with CDROMs and cannot be automatically rebooted:"
print "\n".join(sorted(was_running_cd))

print "\nThe following VMs need to be booted:"
print "\n".join(sorted(to_be_booted))
