<%
from invirt.config import structs as cfg
hostname = cfg.web.hostname
errmail  = cfg.web.errormail
tracuri  = cfg.trac.uri
%>
NameVirtualHost *:80
<VirtualHost *:80>
	ServerAdmin ${errmail}
        ServerName ${hostname}:80
	
	DocumentRoot /var/www/invirt-web
	<Directory /var/www/invirt-web>
		Options Indexes FollowSymLinks MultiViews ExecCGI
		AllowOverride None
		Order allow,deny
		allow from all
	</Directory>

	RewriteEngine On
	RewriteRule ^/static(.*) - [L]
	RewriteRule ^/admin/static(.*) /static/$1 [L]
	RewriteRule ^/trac(.*) ${tracuri}$1 [R,L]
	RewriteRule ^/invirt - [L]
	RewriteRule ^/(.*) /var/www/invirt-web/unauth.fcgi/$1 [L]

	ErrorLog /var/log/apache2/error.log

	# Possible values include: debug, info, notice, warn, error, crit,
	# alert, emerg.
	LogLevel notice

	CustomLog /var/log/apache2/access.log combined
	ServerSignature On
</VirtualHost>
