# Anemon Dhcp
# Copyright (C) 2005 Mathieu Ignacio -- mignacio@april.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA


import sys
from anemon.server import db_classes
from anemon.server import db_functions
from anemon.server import dhcp_core
from anemon.server import sysconf
from anemon.server import dhcp_backend
from anemon.server import dhcp_server
from anemon.server import event_logger


options = { "server_listen_port":sysconf.server_listen_port,
            "client_listen_port":sysconf.client_listen_port,
            "listen_address":sysconf.listen_address}





try : db_classes.init(sysconf.database_uri)
except : event_logger.exception("db_classes.init exception. Anemon server stopped.")

try : db_functions.init()
except : event_logger.exception("db_functions.init exception. Anemon server stopped.")

core = dhcp_core.DhcpCore()
core.SetDefaultGiaddr(sysconf.default_giaddr)

backend = dhcp_backend.DhcpBackend(core)

server = dhcp_server.DhcpServer(backend,options)

while True : server.GetNextDhcpPacket()

