"""Invirt authorization.

This module acts as a loader for the pluggable authorization system.

Any Python module which wishes to provide an authorization scheme for
Invirt should advertise an entry point in the invirt.authz group with
a unique name. That name can then be configured in
/etc/invirt/master.yaml as the authz mechanism.
"""


import pkg_resources

from invirt.config import structs as cfg


def expandOwner(name):
    """Expand an "owner" to a list of authorized users."""
    for ep in pkg_resources.iter_entry_points('invirt.authz', cfg.authz.name):
        return ep.load().expandOwner(name)


def expandAdmin(name):
    """Expand an "administrator" to a list of authorized users."""
    for ep in pkg_resources.iter_entry_points('invirt.authz', cfg.authz.name):
        return ep.load().expandAdmin(name)


__all__ = ['expandOwner',
           'expandAdmin',
           ]
