<%page expression_filter="h"/>
<%inherit file="skeleton.mako" />

<%def name="title()">
Info on ${machine.name}
</%def>

<%def name="infoTable()">
<h2>Info</h2>
<table>
  % for key, value in fields:
  <tr><td>${key}:</td><td>${value}</td></tr>
  % endfor
</table>
</%def>

<%def name="commands()">
% if on:
 % if not machine.type.hvm:
  Console access: type
  <tt>ssh ${machine.name}@${config.console.hostname}</tt>
  on Athena. <a href="https://xvm.scripts.mit.edu/wiki/SerialConsole">(more info)</a>
 % elif has_vnc:
  <strong><a href="machine/${machine.machine_id}/vnc">Get Console</a></strong>
 % else:
  VNC console not enabled; still booting?
 % endif
% endif
<%def name="command_button(title, value, cdrom=False, extra='')">
<form action="machine/${machine.machine_id}/command/${value}" method="POST">
  <input type="hidden" name="back" value="info" />
  <input type="submit" class="button" name="action" value="${title}" ${extra | n}/>
% if cdrom:
  Boot CD: ${self.fn.cdromList()}
% endif
</form>
</%def>
  <div>
	% if on:
	${command_button("Power off", "destroy")}
	${command_button("Shutdown", "shutdown")}
	${command_button("Reboot", "reboot", cdrom=True)}
	% else:
	${command_button("Power on", "create", cdrom=True)}
	% endif
  </div>
  <div>
	${command_button("Delete VM", "delete", extra='''onclick="return confirm('Are you sure that you want to delete this VM?');"''')}
  </div>
</form>
</%def>

<%def name="modifyForm()">
% if err:
<p class="error">We had a problem with your request:</p>
% elif new_machine:
<p>Successfully modified.</p>
% endif
% if on:
(To edit ram, disk size, or machine name, turn off the machine first.)
% endif
<form action="machine/${machine.machine_id}/modify" method="POST">
  <table>
    <tr><td>Description:</td><td colspan="2"><textarea name="description" rows="4" cols="60">${defaults.description}</textarea></td></tr>
    <tr><td>Owner${self.fn.helppopup("Owner")}:</td><td><input type="text" name="owner", value="${defaults.owner}"/></td></tr>
${self.fn.errorRow('owner', err)}
    <tr><td>Administrator${self.fn.helppopup("Administrator")}:</td><td><input type="text" name="admin", value="${defaults.administrator}"/></td></tr>
${self.fn.errorRow('administrator', err)}
    <tr><td>Contact email:</td><td><input type="text" name="contact" value="${defaults.contact}"/></td></tr>
${self.fn.errorRow('contact', err)}
% if not on:
    <tr><td>Machine Name:</td><td><input type="text" name="name" value="${defaults.name}"/>.${config.dns.domains[0]}</td></tr>
${self.fn.errorRow('name', err)}
    <tr>
      <td>HVM/ParaVM${self.fn.helppopup('HVM/ParaVM')}</td>
      <td>${self.fn.vmTypeList(defaults.type)}</td>
    </tr>
    <tr><td>Ram:</td><td><input type="text" size=3 name="memory" value="${defaults.memory}"/>MiB (max ${max_mem})</td></tr>
${self.fn.errorRow('memory', err)}
    <tr><td>Disk:</td><td><input type="text" size=3 name="disksize" value="${defaults.disk}"/>GiB (max ${max_disk})</td><td>WARNING: Modifying disk size may corrupt your data.</td></tr>
${self.fn.errorRow('disk', err)}
% else:
${self.fn.errorRow('name', err)}
${self.fn.errorRow('memory', err)}
${self.fn.errorRow('disk', err)}
% endif
    <tr><td><input type="submit" class="button" name="action" value="Change"/></td></tr>
  </table>
</form>
</%def>

<div id="info">
  ${infoTable()}
</div>

<h2>Commands</h2>
<div id="commands">
  ${commands()}
</div>
<h2>Settings</h2>
<div id="modify">
  ${modifyForm()}
</div>
