#!/usr/bin/python

from os import path
from debian_bundle.changelog import Changelog
from debian_bundle.deb822 import Deb822
from email.utils import parseaddr
from glob import glob
from setuptools import setup

version = Changelog(open(path.join(path.dirname(__file__), 'debian/changelog')).read()).\
    get_version().full_version

maintainer_full = Deb822(open(path.join(path.dirname(__file__), 'debian/control')))['Maintainer']
maintainer, maintainer_email = parseaddr(maintainer_full)

setup(
    name='invirt.builder',
    version=version,
    maintainer=maintainer,
    maintainer_email=maintainer_email,

    py_modules = ['invirt.builder'],
    package_dir = {'': 'python'},
    scripts = ['invirtibuilder', 'invirt-build-conf', 'invirt-submit-build']
)
