#!/usr/bin/python

from os import path
from email.utils import parseaddr
from glob import glob
from setuptools import setup, find_packages

try:
    from debian_bundle.changelog import Changelog
    from debian_bundle.deb822 import Deb822
    version = Changelog(open(path.join(path.dirname(__file__), 'debian/changelog')).read()).\
        get_version().full_version

    maintainer_full = Deb822(open(path.join(path.dirname(__file__), 'debian/control')))['Maintainer']
    maintainer, maintainer_email = parseaddr(maintainer_full)
except:
    version = '0.0.0'
    maintainer, maintainer_email = parseaddr('Invirt project <invirt@mit.edu>')

setup(
    name='xvm.authz.locker',
    version=version,
    maintainer=maintainer,
    maintainer_email=maintainer_email,
    
    packages=find_packages('python'),
    package_dir = {'': 'python'},
)
