#!/bin/bash
set -e

# Depends: python-yaml, python-mako
# and svn-all-fast-export, which comes from git://repo.or.cz/svn-all-fast-export
# (except you actually want git://andersk.mit.edu/svn-all-fast-export localtime)
# and builds with `qmake && make` with
#   Build-Depends: libqt4-dev, libsvn-dev

# Usage: ./git-migrate-fast.sh [svn-uri]
# Exports into new subdir ./git .
SVN=${1:-/mit/xvm/svn}

mako-render rules.mako > rules

rm git -rf
mkdir git
cd git

sed -n 's/^create repository // p' ../rules | while read repo; do
    mkdir -p "$repo" && GIT_DIR="$repo" git init --bare
done

svn-all-fast-export --identity-map ../authors ../rules "$SVN"

pushd packages/invirt-dev.git
GIT_COMMITTER_NAME='Eric Price' GIT_COMMITTER_EMAIL='ecprice@mit.edu' GIT_COMMITTER_DATE='1206829393 -0400' \
    git tag -a sipb-xen-dev/13 sipb-xen-dev/14~2 -F - <<EOF
Tag 13 of sipb-xen-dev

svn path=/package_tags/sipb-xen-dev/13/; revision=316
EOF
popd

pushd packages/invirt-remote.git
echo $(git rev-parse 0.2.0^0 invirt-remote-server invirt-remote-host) >> info/grafts
git filter-branch --tag-name-filter cat -- ^invirt-remote-server ^invirt-remote-host --all
rm -rf info/grafts refs/original refs/heads/invirt-remote-server refs/heads/invirt-remote-host
popd

pushd packages/invirt-console.git
echo $(git rev-parse 0.2.0^0 0.2.0^ invirt-console-host) >> info/grafts
git filter-branch --tag-name-filter cat -- ^0.2.0^ ^invirt-console-host --all
rm -rf info/grafts refs/original refs/heads/invirt-console-host
popd

pushd packages/invirt-dns.git
echo $(git rev-parse sipb-xen-dns/1~10 sipb-xen-dns/1~11 dns) >> info/grafts
git filter-branch --tag-name-filter cat -- ^sipb-xen-dns/1~11 ^dns --all
rm -rf info/grafts refs/original refs/heads/dns
popd

pushd packages/invirt-database.git
echo $(git rev-parse invirt-database-server/0.0.1^0 0.0.1^) >> info/grafts
echo $(git rev-parse 0.2.0^0 0.2.0^ invirt-database-server) >> info/grafts
git filter-branch --tag-name-filter cat -- ^0.2.0^ --all
rm -rf info/grafts refs/original refs/heads/invirt-database-server
popd

pushd packages/python-routefs.git
git fetch -t git://github.com/ebroder/python-routefs.git
git branch -f upstream 1.0.1
git branch -f master 1.0.1-1
popd

echo
echo 'The Git migration was successful.'
