#!/usr/bin/python
from sipb_xen_database import *
import sys
import getafsgroups
import subprocess

def expandLocker(name):
    groups = getafsgroups.getLockerAcl(name)
    cell = getafsgroups.getCell(name)
    ans = set()
    for group in groups:
        if ':' in group:
            ans.update(getafsgroups.getAfsGroupMembers(group, cell))
        else:
            ans.add(group)
    return ans

def isUser(name):
    p = subprocess.Popen(['vos', 'examine', 'user.'+name],
                         stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    if p.wait():
        return False
    return True
    

def expandName(name):
    if ':' not in name:
        if isUser(name):
            return [name]
        name = 'system:'+name
    return getafsgroups.getAfsGroupMembers(name, 'athena.mit.edu')

if __name__ == '__main__':
    connect('postgres://sipb-xen@sipb-xen-dev/sipb_xen')
    
    machines = Machine.select()
    for m in machines:
        people = set()
        people.update(expandLocker(m.owner))
        people.update(expandName(m.administrator))
        print '%s: %s' % (m.name, ' '.join(people))
        transaction = ctx.current.create_transaction()
        for u in m.users:
            ctx.current.delete(u)
        for p in people:
            ma = MachineAccess(machine_id=m.machine_id, user=p)
            ctx.current.save(ma)
        ctx.current.flush()
        transaction.commit()
