# For a package which only configures another, "parent" package.
#
# Usage:
#   PACKAGE=short-name
#   GEN_FILES=(files to generate)
#   PARENTPACKAGE=(parent-package another-parent-package)
#   . /lib/init/config-init.sh
#   config_init "$1"
#
# PACKAGE       - name to appear in log message
# GEN_FILES     - files to be generated with gen-files.sh
# PARENTPACKAGE - packages to receive start, etc, commands passed through
#
# Global variables GEN_FILES, PARENTPACKAGE may be unset for zero
# values, or scalars for one.  If run under sh, they cannot be arrays.

. /lib/init/vars.sh
. /lib/lsb/init-functions
. /lib/init/gen-files.sh

if [ $BASH_VERSION ]; then
  handle_parents () {
    for p in "${PARENTPACKAGE[@]}"; do
      invoke-rc.d "$p" "$1"
    done
  }
else
  handle_parents () {
    if [ -n "$PARENTPACKAGE" ]; then
      invoke-rc.d "$PARENTPACKAGE" "$1"
    fi
  }
fi

config_init () {
  case "$1" in
    start|reload|force-reload|restart)
      log_begin_msg "Reloading config for $PACKAGE"
      gen_files
      log_end_msg $?
      handle_parents "$1"
      ;;
    stop)
      handle_parents "$1"
      ;;
    *)
      log_success_msg "Usage: /etc/init.d/$PACKAGE {start|reload|force-reload|restart|stop}"
      ;;
  esac
}
