class Record(object):
    _identity_field = None
    _default = {}
    _format = {}

    def get(self, field):
        v = getattr(self, field, None)
        if v is None:
            return self._default.get(field)
        return v

    def _formatField(self, field):
        v = self.get(field)
        func = self._format.get(field)
        if func:
            return func(v)
        if callable(v):
            v = v()
        if not hasattr(v, '__iter__'):
            return repr(v)
        if len(v) == 0:
            return '[]'
        return '[%d x %s]'%(len(v), type(v[0]).__name__)

    @classmethod
    def _ignore(cls):
        return [cls._identity_field]

    def _fields(self):
        ignore = self._ignore()
        keys = sorted(self.c.keys())
        return [(k,self._formatField(k)) for k in keys if k not in ignore]

    def __repr__(self):
        classname = self.__class__.__name__

        if self._identity_field:
            identity = self.__dict__.get(self._identity_field)
            identity = ' ' + (identity and repr(identity) or 'hash=%X'%hash(self))
        else:
            identity = ''

        payload = " ".join(["%s=%s" % (k, v) for k,v in self._fields()])
        if len(payload) > 0:
            payload = ": "+payload

        return "<%s%s%s>" % (classname, identity, payload)
