#!/bin/bash
set -e

# Depends: python-yaml, python-mako
# and svn-all-fast-export, which comes from git://repo.or.cz/svn-all-fast-export
# and builds with `qmake && make` with
#   Build-Depends: qt4-qmake, libqt4-dev, libsvn-dev

# Usage: ./git-migrate-fast.sh [svn-uri]
# Exports into new subdir ./git .
SVN=${1:-/mit/xvm/svn}

mako-render rules.mako > rules

rm git -rf
mkdir git
cd git

sed -n 's/^create repository // p' ../rules | while read repo; do
    mkdir -p "$repo" && GIT_DIR="$repo" git init --bare
done

svn-all-fast-export --identity-map ../authors ../rules "$SVN"

sed -n 's/^create repository // p' ../rules | while read repo; do
    if [ -e "$repo/refs/heads/tags" ]; then
        cp -a "$repo/refs/heads/tags/." "$repo/refs/tags"
        rm -rf "$repo/refs/heads/tags"
    fi
done

pushd packages/invirt-dev.git
git tag sipb-xen-dev/13 sipb-xen-dev/14~2
popd

pushd packages/invirt-remote.git
echo $(git rev-parse 0.2.0 invirt-remote-server invirt-remote-host) >> info/grafts
git filter-branch --tag-name-filter cat -- ^invirt-remote-server ^invirt-remote-host --all
rm -rf info/grafts refs/original refs/heads/invirt-remote-server refs/heads/invirt-remote-host
popd

pushd packages/invirt-console.git
echo $(git rev-parse 0.2.0 0.2.0^ invirt-console-host) >> info/grafts
git filter-branch --tag-name-filter cat -- ^0.2.0^ ^invirt-console-host --all
rm -rf info/grafts refs/original refs/heads/invirt-console-host
popd

pushd packages/invirt-dns.git
echo $(git rev-parse sipb-xen-dns/1~10 sipb-xen-dns/1~11 dns) >> info/grafts
git filter-branch --tag-name-filter cat -- ^sipb-xen-dns/1~11 ^dns --all
rm -rf info/grafts refs/original refs/heads/dns
popd

pushd packages/invirt-database.git
echo $(git rev-parse invirt-database-server/0.0.1 0.0.1^) >> info/grafts
echo $(git rev-parse 0.2.0 0.2.0^ invirt-database-server) >> info/grafts
git filter-branch --tag-name-filter cat -- ^0.2.0^ --all
rm -rf info/grafts refs/original refs/heads/invirt-database-server
popd

pushd packages/python-routefs.git
git fetch -t git://github.com/ebroder/python-routefs.git
git branch -f upstream 1.0.1
git branch -f master 1.0.1-1
popd

echo
echo 'The Git migration was successful.'
